/*
 * Decompiled with CFR 0.152.
 */
package unluac.decompile.block;

import unluac.decompile.CloseType;
import unluac.decompile.Decompiler;
import unluac.decompile.Output;
import unluac.decompile.block.Block;
import unluac.decompile.block.ContainerBlock;
import unluac.decompile.block.IfThenElseBlock;
import unluac.decompile.block.IfThenEndBlock;
import unluac.decompile.statement.Statement;
import unluac.parse.LFunction;

public class ElseEndBlock
extends ContainerBlock {
    public IfThenElseBlock partner;

    public ElseEndBlock(LFunction lFunction, int n, int n2, CloseType closeType, int n3) {
        super(lFunction, n, n2, closeType, n3, -1);
    }

    @Override
    public int compareTo(Block block) {
        if (block == this.partner) {
            return 1;
        }
        int n = super.compareTo(block);
        return n;
    }

    @Override
    public boolean breakable() {
        return false;
    }

    @Override
    public int scopeEnd() {
        return this.usingClose && this.closeType == CloseType.CLOSE ? this.closeLine - 1 : super.scopeEnd();
    }

    @Override
    public boolean hasHeader() {
        return true;
    }

    @Override
    public boolean isUnprotected() {
        return false;
    }

    @Override
    public int getLoopback() {
        throw new IllegalStateException();
    }

    @Override
    public void print(Decompiler decompiler, Output output) {
        if (this.statements.size() == 1 && this.statements.get(0) instanceof IfThenEndBlock) {
            output.print("else");
            ((Statement)this.statements.get(0)).print(decompiler, output);
        } else if (this.statements.size() == 2 && this.statements.get(0) instanceof IfThenElseBlock && this.statements.get(1) instanceof ElseEndBlock) {
            output.print("else");
            ((Statement)this.statements.get(0)).print(decompiler, output);
            ((Statement)this.statements.get(1)).print(decompiler, output);
        } else {
            output.print("else");
            output.println();
            output.indent();
            Statement.printSequence(decompiler, output, this.statements);
            output.dedent();
            output.print("end");
        }
    }
}

