/*
 * Decompiled with CFR 0.152.
 */
package unluac.decompile.block;

import java.util.ArrayList;
import java.util.List;
import unluac.decompile.CloseType;
import unluac.decompile.Walker;
import unluac.decompile.block.Block;
import unluac.decompile.statement.Statement;
import unluac.parse.LFunction;

public abstract class ContainerBlock
extends Block {
    protected final List<Statement> statements;
    protected final CloseType closeType;
    protected final int closeLine;
    protected boolean usingClose;

    public ContainerBlock(LFunction lFunction, int n, int n2, CloseType closeType, int n3, int n4) {
        super(lFunction, n, n2, n4);
        this.closeType = closeType;
        this.closeLine = n3;
        this.usingClose = false;
        this.statements = new ArrayList<Statement>(Math.max(4, n2 - n + 1));
    }

    @Override
    public void walk(Walker walker) {
        walker.visitStatement(this);
        for (Statement statement : this.statements) {
            statement.walk(walker);
        }
    }

    @Override
    public boolean isContainer() {
        return this.begin < this.end;
    }

    @Override
    public boolean isEmpty() {
        return this.statements.isEmpty();
    }

    @Override
    public void addStatement(Statement statement) {
        this.statements.add(statement);
    }

    @Override
    public boolean hasCloseLine() {
        return this.closeType != CloseType.NONE;
    }

    @Override
    public int getCloseLine() {
        if (this.closeType == CloseType.NONE) {
            throw new IllegalStateException();
        }
        return this.closeLine;
    }

    @Override
    public void useClose() {
        this.usingClose = true;
    }
}

