/*
 * Decompiled with CFR 0.152.
 */
package unluac.decompile.block;

import java.util.Arrays;
import java.util.List;
import unluac.decompile.CloseType;
import unluac.decompile.Decompiler;
import unluac.decompile.Registers;
import unluac.decompile.operation.Operation;
import unluac.decompile.statement.Statement;
import unluac.parse.LFunction;

public abstract class Block
extends Statement
implements Comparable<Block> {
    protected final LFunction function;
    public int begin;
    public int end;
    public int closeRegister;
    private final int priority;
    public boolean loopRedirectAdjustment = false;
    protected boolean scopeUsed = false;

    public Block(LFunction lFunction, int n, int n2, int n3) {
        this.function = lFunction;
        this.begin = n;
        this.end = n2;
        this.closeRegister = -1;
        this.priority = n3;
    }

    public abstract void addStatement(Statement var1);

    public void resolve(Registers registers) {
    }

    public boolean contains(Block block) {
        return this.contains(block.begin, block.end);
    }

    public boolean contains(int n) {
        return this.begin <= n && n < this.end;
    }

    public boolean contains(int n, int n2) {
        return this.begin <= n && this.end >= n2;
    }

    public int scopeEnd() {
        return this.end - 1;
    }

    public void useScope() {
        this.scopeUsed = true;
    }

    public boolean hasCloseLine() {
        return false;
    }

    public int getCloseLine() {
        throw new IllegalStateException();
    }

    public void useClose() {
        throw new IllegalStateException();
    }

    public abstract boolean hasHeader();

    public abstract boolean isUnprotected();

    public int getUnprotectedTarget() {
        throw new IllegalStateException(this.toString());
    }

    public int getUnprotectedLine() {
        throw new IllegalStateException(this.toString());
    }

    public abstract int getLoopback();

    public abstract boolean breakable();

    public abstract boolean isContainer();

    public abstract boolean isEmpty();

    public boolean allowsPreDeclare() {
        return false;
    }

    public boolean isSplitable() {
        return false;
    }

    public Block[] split(int n, CloseType closeType) {
        throw new IllegalStateException();
    }

    @Override
    public int compareTo(Block block) {
        if (this.begin < block.begin) {
            return -1;
        }
        if (this.begin == block.begin) {
            if (this.end < block.end) {
                return 1;
            }
            if (this.end == block.end) {
                return this.priority - block.priority;
            }
            return -1;
        }
        return 1;
    }

    public Operation process(Decompiler decompiler) {
        final Block block = this;
        return new Operation(this, this.end - 1){

            @Override
            public List<Statement> process(Registers registers, Block block2) {
                return Arrays.asList(block);
            }
        };
    }
}

