/*
 * Decompiled with CFR 0.152.
 */
package unluac.decompile.block;

import unluac.Version;
import unluac.decompile.CloseType;
import unluac.decompile.Decompiler;
import unluac.decompile.Function;
import unluac.decompile.Output;
import unluac.decompile.block.ContainerBlock;
import unluac.decompile.expression.ConstantExpression;
import unluac.decompile.statement.Statement;
import unluac.parse.LFunction;

public class AlwaysLoop
extends ContainerBlock {
    private final boolean repeat;
    private ConstantExpression condition;
    private Version.WhileFormat whileFormat;

    public AlwaysLoop(LFunction lFunction, int n, int n2, CloseType closeType, int n3, boolean bl) {
        super(lFunction, n, n2, closeType, n3, 0);
        this.repeat = bl;
        this.whileFormat = lFunction.header.version.whileformat.get();
        this.condition = null;
    }

    @Override
    public int scopeEnd() {
        return this.usingClose && this.closeType == CloseType.CLOSE ? this.closeLine - 1 : this.end - 2;
    }

    @Override
    public boolean breakable() {
        return true;
    }

    @Override
    public boolean hasHeader() {
        if (this.whileFormat == Version.WhileFormat.BOTTOM_CONDITION) {
            return !this.repeat;
        }
        return false;
    }

    @Override
    public boolean isUnprotected() {
        return true;
    }

    @Override
    public int getUnprotectedTarget() {
        return this.begin;
    }

    @Override
    public int getUnprotectedLine() {
        return this.end - 1;
    }

    @Override
    public int getLoopback() {
        return this.begin;
    }

    @Override
    public void print(Decompiler decompiler, Output output) {
        if (this.repeat) {
            output.println("repeat");
        } else {
            output.print("while ");
            if (this.condition == null) {
                output.print("true");
            } else {
                this.condition.print(decompiler, output);
            }
            output.println(" do");
        }
        output.indent();
        Statement.printSequence(decompiler, output, this.statements);
        output.dedent();
        if (this.repeat) {
            output.print("until false");
        } else {
            output.print("end");
        }
    }

    @Override
    public boolean useConstant(Function function, int n) {
        if (!this.repeat && this.condition == null) {
            this.condition = function.getConstantExpression(n);
            return true;
        }
        return false;
    }
}

