/*
 * Decompiled with CFR 0.152.
 */
package unluac.decompile;

import java.util.Map;
import unluac.Version;
import unluac.decompile.Type;

public class TypeMap {
    private Type[] types;
    public final int NIL;
    public final int BOOLEAN;
    public final int FALSE;
    public final int TRUE;
    public final int NUMBER;
    public final int FLOAT;
    public final int INTEGER;
    public final int STRING;
    public final int SHORT_STRING;
    public final int LONG_STRING;
    public static final int UNMAPPED = -1;
    private static final int VARIANT = 16;

    public TypeMap(Version.TypeMapType typeMapType) {
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        switch (typeMapType) {
            case LUA50: {
                break;
            }
            case LUA52: {
                bl = true;
                break;
            }
            case LUA53: {
                bl = true;
                bl2 = true;
                break;
            }
            case LUA54: {
                bl = true;
                bl2 = true;
                bl3 = true;
                bl4 = true;
            }
        }
        this.types = new Type[bl ? 21 : 5];
        this.types[0] = Type.NIL;
        this.NIL = 0;
        if (!bl3) {
            this.BOOLEAN = 1;
            this.FALSE = -1;
            this.TRUE = -1;
            this.types[this.BOOLEAN] = Type.BOOLEAN;
        } else {
            this.BOOLEAN = -1;
            this.FALSE = 1;
            this.TRUE = 17;
            this.types[this.FALSE] = Type.FALSE;
            this.types[this.TRUE] = Type.TRUE;
        }
        if (!bl2) {
            this.NUMBER = 3;
            this.FLOAT = -1;
            this.INTEGER = -1;
            this.types[this.NUMBER] = Type.NUMBER;
        } else {
            this.NUMBER = -1;
            if (!bl4) {
                this.FLOAT = 3;
                this.INTEGER = 19;
            } else {
                this.INTEGER = 3;
                this.FLOAT = 19;
            }
            this.types[this.FLOAT] = Type.FLOAT;
            this.types[this.INTEGER] = Type.INTEGER;
        }
        if (!bl) {
            this.STRING = 4;
            this.SHORT_STRING = -1;
            this.LONG_STRING = -1;
            this.types[this.STRING] = Type.STRING;
        } else {
            this.STRING = -1;
            this.SHORT_STRING = 4;
            this.LONG_STRING = 20;
            this.types[this.SHORT_STRING] = Type.SHORT_STRING;
            this.types[this.LONG_STRING] = Type.LONG_STRING;
        }
    }

    public TypeMap(Map<Integer, Type> map) {
        int n = 0;
        for (Integer n2 : map.keySet()) {
            n = Math.max(n, n2);
        }
        this.types = new Type[n + 1];
        int n3 = -1;
        int n4 = -1;
        int n5 = -1;
        int n6 = -1;
        int n7 = -1;
        int n8 = -1;
        int n9 = -1;
        int n10 = -1;
        int n11 = -1;
        int n12 = -1;
        for (Map.Entry<Integer, Type> entry : map.entrySet()) {
            Type type;
            int n13 = entry.getKey();
            this.types[n13] = type = entry.getValue();
            switch (type) {
                case NIL: {
                    n3 = n13;
                    break;
                }
                case BOOLEAN: {
                    n4 = n13;
                    break;
                }
                case FALSE: {
                    n5 = n13;
                    break;
                }
                case TRUE: {
                    n6 = n13;
                    break;
                }
                case NUMBER: {
                    n7 = n13;
                    break;
                }
                case FLOAT: {
                    n8 = n13;
                    break;
                }
                case INTEGER: {
                    n9 = n13;
                    break;
                }
                case STRING: {
                    n10 = n13;
                    break;
                }
                case SHORT_STRING: {
                    n11 = n13;
                    break;
                }
                case LONG_STRING: {
                    n12 = n13;
                }
            }
        }
        this.NIL = n3;
        this.BOOLEAN = n4;
        this.FALSE = n5;
        this.TRUE = n6;
        this.NUMBER = n7;
        this.FLOAT = n8;
        this.INTEGER = n9;
        this.STRING = n10;
        this.SHORT_STRING = n11;
        this.LONG_STRING = n12;
    }

    public int size() {
        return this.types.length;
    }

    public Type get(int n) {
        if (n >= 0 && n < this.types.length) {
            return this.types[n];
        }
        return null;
    }
}

