/*
 * Decompiled with CFR 0.152.
 */
package unluac.decompile;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import unluac.Version;
import unluac.decompile.Declaration;
import unluac.decompile.Function;
import unluac.decompile.expression.ConstantExpression;
import unluac.decompile.expression.Expression;
import unluac.decompile.expression.LocalVariable;
import unluac.decompile.target.Target;
import unluac.decompile.target.VariableTarget;

public class Registers {
    public final int registers;
    public final int length;
    private final Declaration[][] decls;
    private final Function f;
    public final boolean isNoDebug;
    private final Expression[][] values;
    private final int[][] updated;
    private boolean[] startedLines;

    public Registers(int n, int n2, Declaration[] declarationArray, Function function, boolean bl) {
        this.registers = n;
        this.length = n2;
        this.decls = new Declaration[n][n2 + 1];
        for (int i = 0; i < declarationArray.length; ++i) {
            Declaration declaration = declarationArray[i];
            int n3 = 0;
            while (this.decls[n3][declaration.begin] != null) {
                ++n3;
            }
            declaration.register = n3;
            for (int j = declaration.begin; j <= declaration.end; ++j) {
                this.decls[n3][j] = declaration;
            }
        }
        this.values = new Expression[n][n2 + 1];
        ConstantExpression constantExpression = ConstantExpression.createNil(0);
        for (int i = 0; i < n; ++i) {
            this.values[i][0] = constantExpression;
        }
        this.updated = new int[n][n2 + 1];
        this.startedLines = new boolean[n2 + 1];
        Arrays.fill(this.startedLines, false);
        this.f = function;
        this.isNoDebug = bl;
    }

    public Function getFunction() {
        return this.f;
    }

    public boolean isAssignable(int n, int n2) {
        return this.isLocal(n, n2) && (!this.decls[n][n2].forLoop || this.isNoDebug);
    }

    public boolean isLocal(int n, int n2) {
        if (n < 0) {
            return false;
        }
        return this.decls[n][n2] != null;
    }

    public boolean isNewLocal(int n, int n2) {
        Declaration declaration = this.decls[n][n2];
        return declaration != null && declaration.begin == n2 && !declaration.forLoop && !declaration.forLoopExplicit;
    }

    public List<Declaration> getNewLocals(int n) {
        return this.getNewLocals(n, 0);
    }

    public List<Declaration> getNewLocals(int n, int n2) {
        n2 = Math.max(0, n2);
        ArrayList<Declaration> arrayList = new ArrayList<Declaration>(Math.max(this.registers - n2, 0));
        for (int i = n2; i < this.registers; ++i) {
            if (!this.isNewLocal(i, n)) continue;
            arrayList.add(this.getDeclaration(i, n));
        }
        return arrayList;
    }

    public Declaration getDeclaration(int n, int n2) {
        return this.decls[n][n2];
    }

    public void startLine(int n) {
        this.startedLines[n] = true;
        for (int i = 0; i < this.registers; ++i) {
            this.values[i][n] = this.values[i][n - 1];
            this.updated[i][n] = this.updated[i][n - 1];
        }
    }

    public boolean isKConstant(int n) {
        return this.f.isConstant(n);
    }

    public Expression getExpression(int n, int n2) {
        if (this.isLocal(n, n2 - 1)) {
            return new LocalVariable(this.getDeclaration(n, n2 - 1));
        }
        return this.values[n][n2 - 1];
    }

    public Expression getKExpression(int n, int n2) {
        if (this.f.isConstant(n)) {
            return this.f.getConstantExpression(this.f.constantIndex(n));
        }
        return this.getExpression(n, n2);
    }

    public Expression getKExpression54(int n, boolean bl, int n2) {
        if (bl) {
            return this.f.getConstantExpression(n);
        }
        return this.getExpression(n, n2);
    }

    public Expression getValue(int n, int n2) {
        if (this.isNoDebug) {
            return this.getExpression(n, n2);
        }
        return this.values[n][n2 - 1];
    }

    public int getUpdated(int n, int n2) {
        return this.updated[n][n2];
    }

    public void setValue(int n, int n2, Expression expression) {
        this.values[n][n2] = expression;
        this.updated[n][n2] = n2;
    }

    public Target getTarget(int n, int n2) {
        if (!this.isLocal(n, n2)) {
            throw new IllegalStateException("No declaration exists in register " + n + " at line " + n2);
        }
        return new VariableTarget(this.decls[n][n2]);
    }

    public void setInternalLoopVariable(int n, int n2, int n3) {
        Declaration declaration = this.getDeclaration(n, n2);
        if (declaration == null) {
            declaration = new Declaration("_FOR_", n2, n3);
            declaration.register = n;
            this.newDeclaration(declaration, n, n2, n3);
            if (!this.isNoDebug) {
                throw new IllegalStateException("TEMP");
            }
        } else if (!(this.isNoDebug || declaration.begin == n2 && declaration.end == n3)) {
            System.err.println("given: " + n2 + " " + n3);
            System.err.println("expected: " + declaration.begin + " " + declaration.end);
            throw new IllegalStateException();
        }
        declaration.forLoop = true;
    }

    public void setExplicitLoopVariable(int n, int n2, int n3) {
        Declaration declaration = this.getDeclaration(n, n2);
        if (declaration == null) {
            declaration = new Declaration("_FORV_" + n + "_", n2, n3);
            declaration.register = n;
            this.newDeclaration(declaration, n, n2, n3);
            if (!this.isNoDebug) {
                throw new IllegalStateException("TEMP");
            }
        } else if (!(this.isNoDebug || declaration.begin == n2 && declaration.end == n3)) {
            System.err.println("given: " + n2 + " " + n3);
            System.err.println("expected: " + declaration.begin + " " + declaration.end);
            throw new IllegalStateException();
        }
        declaration.forLoopExplicit = true;
    }

    private void newDeclaration(Declaration declaration, int n, int n2, int n3) {
        for (int i = n2; i <= n3; ++i) {
            this.decls[n][i] = declaration;
        }
    }

    public Version getVersion() {
        return this.f.getVersion();
    }
}

