/*
 * Decompiled with CFR 0.152.
 */
package unluac.decompile;

import unluac.decompile.OutputProvider;

public class Output {
    private OutputProvider out;
    private int indentationLevel = 0;
    private int position = 0;
    private boolean start = true;
    private boolean paragraph = false;

    public Output() {
        this(new OutputProvider(){

            @Override
            public void print(String string) {
                System.out.print(string);
            }

            @Override
            public void print(byte by) {
                System.out.write(by);
            }

            @Override
            public void println() {
                System.out.println();
            }

            @Override
            public void finish() {
                System.out.flush();
            }
        });
    }

    public Output(OutputProvider outputProvider) {
        this.out = outputProvider;
    }

    public void indent() {
        this.start = true;
        this.indentationLevel += 2;
    }

    public void dedent() {
        this.paragraph = false;
        this.indentationLevel -= 2;
    }

    public void paragraph() {
        this.paragraph = true;
    }

    public int getIndentationLevel() {
        return this.indentationLevel;
    }

    public int getPosition() {
        return this.position;
    }

    public void setIndentationLevel(int n) {
        this.indentationLevel = n;
    }

    private void start() {
        if (this.position == 0) {
            for (int i = this.indentationLevel; i != 0; --i) {
                this.out.print(" ");
                ++this.position;
            }
            if (this.paragraph && !this.start) {
                this.paragraph = false;
                this.out.println();
                this.position = 0;
                this.start();
            }
        }
        this.start = false;
    }

    public void print(String string) {
        this.start();
        for (int i = 0; i < string.length(); ++i) {
            this.out.print((byte)string.charAt(i));
        }
        this.position += string.length();
    }

    public void print(byte by) {
        this.start();
        this.out.print(by);
        ++this.position;
    }

    public void println() {
        this.start();
        this.out.println();
        this.position = 0;
    }

    public void println(String string) {
        this.print(string);
        this.println();
    }

    public void finish() {
        this.out.finish();
    }
}

