/*
 * Decompiled with CFR 0.152.
 */
package unluac.decompile;

import unluac.Version;
import unluac.decompile.CodeExtract;
import unluac.decompile.OperandFormat;
import unluac.parse.LFunction;

public enum Op {
    MOVE("move", 31, OperandFormat.AR, OperandFormat.BR),
    LOADK("loadk", 31, OperandFormat.AR, OperandFormat.BxK),
    LOADBOOL("loadbool", 15, OperandFormat.AR, OperandFormat.B, OperandFormat.C),
    LOADNIL("loadnil", 3, OperandFormat.AR, OperandFormat.BR),
    GETUPVAL("getupval", 31, OperandFormat.AR, OperandFormat.BU),
    GETGLOBAL("getglobal", 3, OperandFormat.AR, OperandFormat.BxK),
    GETTABLE("gettable", 15, OperandFormat.AR, OperandFormat.BR, OperandFormat.CRK),
    SETGLOBAL("setglobal", 3, OperandFormat.AR, OperandFormat.BxK),
    SETUPVAL("setupval", 31, OperandFormat.AR, OperandFormat.BU),
    SETTABLE("settable", 15, OperandFormat.AR, OperandFormat.BRK, OperandFormat.CRK),
    NEWTABLE("newtable", 14, OperandFormat.AR, OperandFormat.B, OperandFormat.C),
    SELF("self", 15, OperandFormat.AR, OperandFormat.BR, OperandFormat.CRK),
    ADD("add", 15, OperandFormat.AR, OperandFormat.BRK, OperandFormat.CRK),
    SUB("sub", 15, OperandFormat.AR, OperandFormat.BRK, OperandFormat.CRK),
    MUL("mul", 15, OperandFormat.AR, OperandFormat.BRK, OperandFormat.CRK),
    DIV("div", 15, OperandFormat.AR, OperandFormat.BRK, OperandFormat.CRK),
    MOD("mod", 14, OperandFormat.AR, OperandFormat.BRK, OperandFormat.CRK),
    POW("pow", 15, OperandFormat.AR, OperandFormat.BRK, OperandFormat.CRK),
    UNM("unm", 15, OperandFormat.AR, OperandFormat.BR),
    NOT("not", 15, OperandFormat.AR, OperandFormat.BR),
    LEN("len", 14, OperandFormat.AR, OperandFormat.BR),
    CONCAT("concat", 15, OperandFormat.AR, OperandFormat.BRK, OperandFormat.CRK),
    JMP("jmp", 3, OperandFormat.sBxJ),
    EQ("eq", 15, OperandFormat.A, OperandFormat.BRK, OperandFormat.CRK),
    LT("lt", 15, OperandFormat.A, OperandFormat.BRK, OperandFormat.CRK),
    LE("le", 15, OperandFormat.A, OperandFormat.BRK, OperandFormat.CRK),
    TEST("test", 14, OperandFormat.AR, OperandFormat.C),
    TESTSET("testset", 14, OperandFormat.AR, OperandFormat.BR, OperandFormat.C),
    CALL("call", 31, OperandFormat.AR, OperandFormat.B, OperandFormat.C),
    TAILCALL("tailcall", 15, OperandFormat.AR, OperandFormat.B),
    RETURN("return", 15, OperandFormat.AR, OperandFormat.B),
    FORLOOP("forloop", 15, OperandFormat.AR, OperandFormat.sBxJ),
    FORPREP("forprep", 14, OperandFormat.AR, OperandFormat.sBxJ),
    TFORLOOP("tforloop", 3, OperandFormat.AR, OperandFormat.C),
    SETLIST("setlist", 2, OperandFormat.AR, OperandFormat.B, OperandFormat.C),
    CLOSE("close", 19, OperandFormat.AR),
    CLOSURE("closure", 31, OperandFormat.AR, OperandFormat.BxF),
    VARARG("vararg", 14, OperandFormat.AR, OperandFormat.B),
    JMP52("jmp", 12, OperandFormat.A, OperandFormat.sBxJ),
    LOADNIL52("loadnil", 28, OperandFormat.AR, OperandFormat.B),
    LOADKX("loadkx", 28, OperandFormat.AR),
    GETTABUP("gettabup", 12, OperandFormat.AR, OperandFormat.BU, OperandFormat.CRK),
    SETTABUP("settabup", 12, OperandFormat.AU, OperandFormat.BRK, OperandFormat.CRK),
    SETLIST52("setlist", 12, OperandFormat.AR, OperandFormat.B, OperandFormat.C),
    TFORCALL("tforcall", 12, OperandFormat.AR, OperandFormat.C),
    TFORLOOP52("tforloop", 12, OperandFormat.AR, OperandFormat.sBxJ),
    EXTRAARG("extraarg", 28, OperandFormat.Ax),
    NEWTABLE50("newtable", 1, OperandFormat.AR, OperandFormat.B, OperandFormat.C),
    SETLIST50("setlist", 1, OperandFormat.AR, OperandFormat.Bx),
    SETLISTO("setlisto", 1, OperandFormat.AR, OperandFormat.Bx),
    TFORPREP("tforprep", 1, OperandFormat.AR, OperandFormat.sBxJ),
    TEST50("test", 1, OperandFormat.AR, OperandFormat.BR, OperandFormat.C),
    IDIV("idiv", 8, OperandFormat.AR, OperandFormat.BRK, OperandFormat.CRK),
    BAND("band", 8, OperandFormat.AR, OperandFormat.BRK, OperandFormat.CRK),
    BOR("bor", 8, OperandFormat.AR, OperandFormat.BRK, OperandFormat.CRK),
    BXOR("bxor", 8, OperandFormat.AR, OperandFormat.BRK, OperandFormat.CRK),
    SHL("shl", 8, OperandFormat.AR, OperandFormat.BRK, OperandFormat.CRK),
    SHR("shr", 8, OperandFormat.AR, OperandFormat.BRK, OperandFormat.CRK),
    BNOT("bnot", 24, OperandFormat.AR, OperandFormat.BR),
    LOADI("loadi", 16, OperandFormat.AR, OperandFormat.sBxI),
    LOADF("loadf", 16, OperandFormat.AR, OperandFormat.sBxF),
    LOADFALSE("loadfalse", 16, OperandFormat.AR),
    LFALSESKIP("lfalseskip", 16, OperandFormat.AR),
    LOADTRUE("loadtrue", 16, OperandFormat.AR),
    GETTABUP54("gettabup", 16, OperandFormat.AR, OperandFormat.BU, OperandFormat.CKS),
    GETTABLE54("gettable", 16, OperandFormat.AR, OperandFormat.BR, OperandFormat.CR),
    GETI("geti", 16, OperandFormat.AR, OperandFormat.BR, OperandFormat.CI),
    GETFIELD("getfield", 16, OperandFormat.AR, OperandFormat.BR, OperandFormat.CKS),
    SETTABUP54("settabup", 16, OperandFormat.AU, OperandFormat.BK, OperandFormat.CRK54),
    SETTABLE54("settable", 16, OperandFormat.AR, OperandFormat.BR, OperandFormat.CRK54),
    SETI("seti", 16, OperandFormat.AR, OperandFormat.BI, OperandFormat.CRK54),
    SETFIELD("setfield", 16, OperandFormat.AR, OperandFormat.BKS, OperandFormat.CRK54),
    NEWTABLE54("newtable", 16, OperandFormat.AR, OperandFormat.B, OperandFormat.C, OperandFormat.k),
    SELF54("self", 16, OperandFormat.AR, OperandFormat.BR, OperandFormat.CRK54),
    ADDI("addi", 16, OperandFormat.AR, OperandFormat.BR, OperandFormat.CsI),
    ADDK("addk", 16, OperandFormat.AR, OperandFormat.BR, OperandFormat.CK),
    SUBK("subk", 16, OperandFormat.AR, OperandFormat.BR, OperandFormat.CK),
    MULK("mulk", 16, OperandFormat.AR, OperandFormat.BR, OperandFormat.CK),
    MODK("modk", 16, OperandFormat.AR, OperandFormat.BR, OperandFormat.CK),
    POWK("powk", 16, OperandFormat.AR, OperandFormat.BR, OperandFormat.CK),
    DIVK("divk", 16, OperandFormat.AR, OperandFormat.BR, OperandFormat.CK),
    IDIVK("idivk", 16, OperandFormat.AR, OperandFormat.BR, OperandFormat.CK),
    BANDK("bandk", 16, OperandFormat.AR, OperandFormat.BR, OperandFormat.CKI),
    BORK("bork", 16, OperandFormat.AR, OperandFormat.BR, OperandFormat.CKI),
    BXORK("bxork", 16, OperandFormat.AR, OperandFormat.BR, OperandFormat.CKI),
    SHRI("shri", 16, OperandFormat.AR, OperandFormat.BR, OperandFormat.CsI),
    SHLI("shli", 16, OperandFormat.AR, OperandFormat.CsI, OperandFormat.BR),
    ADD54("add", 16, OperandFormat.AR, OperandFormat.BR, OperandFormat.CR),
    SUB54("sub", 16, OperandFormat.AR, OperandFormat.BR, OperandFormat.CR),
    MUL54("mul", 16, OperandFormat.AR, OperandFormat.BR, OperandFormat.CR),
    MOD54("mod", 16, OperandFormat.AR, OperandFormat.BR, OperandFormat.CR),
    POW54("pow", 16, OperandFormat.AR, OperandFormat.BR, OperandFormat.CR),
    DIV54("div", 16, OperandFormat.AR, OperandFormat.BR, OperandFormat.CR),
    IDIV54("idiv", 16, OperandFormat.AR, OperandFormat.BR, OperandFormat.CR),
    BAND54("band", 16, OperandFormat.AR, OperandFormat.BR, OperandFormat.CR),
    BOR54("bor", 16, OperandFormat.AR, OperandFormat.BR, OperandFormat.CR),
    BXOR54("bxor", 16, OperandFormat.AR, OperandFormat.BR, OperandFormat.CR),
    SHL54("shl", 16, OperandFormat.AR, OperandFormat.BR, OperandFormat.CR),
    SHR54("shr", 16, OperandFormat.AR, OperandFormat.BR, OperandFormat.CR),
    MMBIN("mmbin", 16, OperandFormat.AR, OperandFormat.BR, OperandFormat.C),
    MMBINI("mmbini", 16, OperandFormat.AR, OperandFormat.BsI, OperandFormat.C, OperandFormat.k),
    MMBINK("mmbink", 16, OperandFormat.AR, OperandFormat.BK, OperandFormat.C, OperandFormat.k),
    CONCAT54("concat", 16, OperandFormat.AR, OperandFormat.B),
    TBC("tbc", 16, OperandFormat.AR),
    JMP54("jmp", 16, OperandFormat.sJ),
    EQ54("eq", 16, OperandFormat.AR, OperandFormat.BR, OperandFormat.k, OperandFormat.C),
    LT54("lt", 16, OperandFormat.AR, OperandFormat.BR, OperandFormat.k, OperandFormat.C),
    LE54("le", 16, OperandFormat.AR, OperandFormat.BR, OperandFormat.k, OperandFormat.C),
    EQK("eqk", 16, OperandFormat.AR, OperandFormat.BK, OperandFormat.k, OperandFormat.C),
    EQI("eqi", 16, OperandFormat.AR, OperandFormat.BsI, OperandFormat.k, OperandFormat.C),
    LTI("lti", 16, OperandFormat.AR, OperandFormat.BsI, OperandFormat.k, OperandFormat.C),
    LEI("lei", 16, OperandFormat.AR, OperandFormat.BsI, OperandFormat.k, OperandFormat.C),
    GTI("gti", 16, OperandFormat.AR, OperandFormat.BsI, OperandFormat.k, OperandFormat.C),
    GEI("gei", 16, OperandFormat.AR, OperandFormat.BsI, OperandFormat.k, OperandFormat.C),
    TEST54("test", 16, OperandFormat.AR, OperandFormat.k),
    TESTSET54("testset", 16, OperandFormat.AR, OperandFormat.BR, OperandFormat.k),
    TAILCALL54("tailcall", 16, OperandFormat.AR, OperandFormat.B, OperandFormat.C, OperandFormat.k),
    RETURN54("return", 16, OperandFormat.AR, OperandFormat.B, OperandFormat.C, OperandFormat.k),
    RETURN0("return0", 16, OperandFormat.AR, OperandFormat.B, OperandFormat.C, OperandFormat.k),
    RETURN1("return1", 16, OperandFormat.AR, OperandFormat.B, OperandFormat.C, OperandFormat.k),
    FORLOOP54("forloop", 16, OperandFormat.AR, OperandFormat.BxJn),
    FORPREP54("forprep", 16, OperandFormat.AR, OperandFormat.BxJ),
    TFORPREP54("tforprep", 16, OperandFormat.AR, OperandFormat.BxJ),
    TFORCALL54("tforcall", 16, OperandFormat.AR, OperandFormat.C),
    TFORLOOP54("tforloop", 16, OperandFormat.AR, OperandFormat.BxJn),
    SETLIST54("setlist", 16, OperandFormat.AR, OperandFormat.B, OperandFormat.C, OperandFormat.k),
    VARARG54("vararg", 16, OperandFormat.AR, OperandFormat.C),
    VARARGPREP("varargprep", 16, OperandFormat.A),
    EXTRABYTE("extrabyte", 31, OperandFormat.x),
    DEFAULT("default", 0, OperandFormat.AR, OperandFormat.BRK, OperandFormat.CRK),
    DEFAULT54("default", 0, OperandFormat.AR, OperandFormat.BR, OperandFormat.C, OperandFormat.k);

    public final String name;
    public final int versions;
    public final OperandFormat[] operands;

    private Op(String string2, int n2) {
        this.name = string2;
        this.versions = n2;
        this.operands = new OperandFormat[0];
    }

    private Op(String string2, int n2, OperandFormat operandFormat) {
        this.name = string2;
        this.versions = n2;
        this.operands = new OperandFormat[]{operandFormat};
    }

    private Op(String string2, int n2, OperandFormat operandFormat, OperandFormat operandFormat2) {
        this.name = string2;
        this.versions = n2;
        this.operands = new OperandFormat[]{operandFormat, operandFormat2};
    }

    private Op(String string2, int n2, OperandFormat operandFormat, OperandFormat operandFormat2, OperandFormat operandFormat3) {
        this.name = string2;
        this.versions = n2;
        this.operands = new OperandFormat[]{operandFormat, operandFormat2, operandFormat3};
    }

    private Op(String string2, int n2, OperandFormat operandFormat, OperandFormat operandFormat2, OperandFormat operandFormat3, OperandFormat operandFormat4) {
        this.name = string2;
        this.versions = n2;
        this.operands = new OperandFormat[]{operandFormat, operandFormat2, operandFormat3, operandFormat4};
    }

    public boolean hasExtraByte(int n, CodeExtract codeExtract) {
        if (this == SETLIST) {
            return codeExtract.C.extract(n) == 0;
        }
        return false;
    }

    public int jumpField(int n, CodeExtract codeExtract) {
        switch (this.ordinal()) {
            case 121: 
            case 122: {
                return codeExtract.Bx.extract(n);
            }
            case 120: 
            case 124: {
                return -codeExtract.Bx.extract(n);
            }
            case 22: 
            case 31: 
            case 32: 
            case 38: 
            case 45: 
            case 50: {
                return codeExtract.sBx.extract(n);
            }
            case 104: {
                return codeExtract.sJ.extract(n);
            }
        }
        throw new IllegalStateException();
    }

    public int target(int n, CodeExtract codeExtract) {
        switch (this.ordinal()) {
            case 0: 
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 27: 
            case 36: 
            case 40: 
            case 41: 
            case 47: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 72: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 102: 
            case 115: {
                return codeExtract.A.extract(n);
            }
            case 99: 
            case 100: 
            case 101: {
                return -1;
            }
            case 3: {
                if (codeExtract.A.extract(n) == codeExtract.B.extract(n)) {
                    return codeExtract.A.extract(n);
                }
                return -1;
            }
            case 39: {
                if (codeExtract.B.extract(n) == 0) {
                    return codeExtract.A.extract(n);
                }
                return -1;
            }
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 38: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 48: 
            case 49: 
            case 50: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 73: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 114: 
            case 116: 
            case 117: 
            case 118: 
            case 119: 
            case 120: 
            case 121: 
            case 122: 
            case 123: 
            case 124: 
            case 125: 
            case 127: {
                return -1;
            }
            case 28: {
                int n2 = codeExtract.A.extract(n);
                int n3 = codeExtract.C.extract(n);
                if (n3 == 1 || n3 == 2) {
                    return n2;
                }
                return -1;
            }
            case 37: {
                int n4 = codeExtract.A.extract(n);
                int n5 = codeExtract.B.extract(n);
                if (n5 == 1 || n5 == 2) {
                    return n4;
                }
                return -1;
            }
            case 126: {
                int n6 = codeExtract.A.extract(n);
                int n7 = codeExtract.C.extract(n);
                if (n7 == 1 || n7 == 2) {
                    return n6;
                }
                return -1;
            }
            case 128: {
                return -1;
            }
            case 129: 
            case 130: {
                throw new IllegalStateException();
            }
        }
        throw new IllegalStateException(this.name());
    }

    private static String fixedOperand(int n) {
        return Integer.toString(n);
    }

    private static String registerOperand(int n) {
        return "r" + n;
    }

    private static String upvalueOperand(int n) {
        return "u" + n;
    }

    private static String constantOperand(int n) {
        return "k" + n;
    }

    private static String functionOperand(int n) {
        return "f" + n;
    }

    public boolean hasJump() {
        for (int i = 0; i < this.operands.length; ++i) {
            OperandFormat.Format format = this.operands[i].format;
            if (format != OperandFormat.Format.JUMP && format != OperandFormat.Format.JUMP_NEGATIVE) continue;
            return true;
        }
        return false;
    }

    public String codePointToString(int n, LFunction lFunction, int n2, CodeExtract codeExtract, String string, boolean bl) {
        return Op.toStringHelper(n, lFunction, this.name, this.operands, n2, codeExtract, string, bl);
    }

    public static String defaultToString(int n, LFunction lFunction, int n2, Version version, CodeExtract codeExtract, boolean bl) {
        return Op.toStringHelper(n, lFunction, String.format("op%02d", codeExtract.op.extract(n2)), version.getDefaultOp().operands, n2, codeExtract, null, bl);
    }

    private static String toStringHelper(int n, LFunction lFunction, String string, OperandFormat[] operandFormatArray, int n2, CodeExtract codeExtract, String string2, boolean bl) {
        int n3 = -1;
        int n4 = 10;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string);
        for (int i = 0; i < n4 - string.length(); ++i) {
            stringBuilder.append(' ');
        }
        String[] stringArray = new String[operandFormatArray.length];
        block24: for (int i = 0; i < operandFormatArray.length; ++i) {
            CodeExtract.Field field = switch (operandFormatArray[i].field) {
                case OperandFormat.Field.A -> codeExtract.A;
                case OperandFormat.Field.B -> codeExtract.B;
                case OperandFormat.Field.C -> codeExtract.C;
                case OperandFormat.Field.k -> codeExtract.k;
                case OperandFormat.Field.Ax -> codeExtract.Ax;
                case OperandFormat.Field.sJ -> codeExtract.sJ;
                case OperandFormat.Field.Bx -> codeExtract.Bx;
                case OperandFormat.Field.sBx -> codeExtract.sBx;
                case OperandFormat.Field.x -> codeExtract.x;
                default -> throw new IllegalStateException();
            };
            int n5 = field.extract(n2);
            switch (operandFormatArray[i].format) {
                case IMMEDIATE_INTEGER: 
                case IMMEDIATE_FLOAT: 
                case RAW: {
                    stringArray[i] = Op.fixedOperand(n5);
                    continue block24;
                }
                case IMMEDIATE_SIGNED_INTEGER: {
                    stringArray[i] = Op.fixedOperand(n5 - field.max() / 2);
                    continue block24;
                }
                case REGISTER: {
                    stringArray[i] = Op.registerOperand(n5);
                    continue block24;
                }
                case UPVALUE: {
                    stringArray[i] = Op.upvalueOperand(n5);
                    continue block24;
                }
                case REGISTER_K: {
                    if (codeExtract.is_k(n5)) {
                        n3 = codeExtract.get_k(n5);
                        stringArray[i] = Op.constantOperand(n3);
                        continue block24;
                    }
                    stringArray[i] = Op.registerOperand(n5);
                    continue block24;
                }
                case REGISTER_K54: {
                    if (codeExtract.k.extract(n2) != 0) {
                        n3 = n5;
                        stringArray[i] = Op.constantOperand(n5);
                        continue block24;
                    }
                    stringArray[i] = Op.registerOperand(n5);
                    continue block24;
                }
                case CONSTANT: 
                case CONSTANT_INTEGER: 
                case CONSTANT_STRING: {
                    n3 = n5;
                    stringArray[i] = Op.constantOperand(n5);
                    continue block24;
                }
                case FUNCTION: {
                    stringArray[i] = Op.functionOperand(n5);
                    continue block24;
                }
                case JUMP: {
                    if (string2 != null) {
                        stringArray[i] = string2;
                        continue block24;
                    }
                    stringArray[i] = Op.fixedOperand(n5 + operandFormatArray[i].offset);
                    continue block24;
                }
                case JUMP_NEGATIVE: {
                    if (string2 != null) {
                        stringArray[i] = string2;
                        continue block24;
                    }
                    stringArray[i] = Op.fixedOperand(-n5);
                    continue block24;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }
        for (String string3 : stringArray) {
            stringBuilder.append(' ');
            for (int i = 0; i < 5 - string3.length(); ++i) {
                stringBuilder.append(' ');
            }
            stringBuilder.append(string3);
        }
        if (bl) {
            stringBuilder.append(" ; upvalue declaration");
        } else if (lFunction != null && n3 >= 0) {
            stringBuilder.append(" ; ");
            stringBuilder.append(Op.constantOperand(n3));
            if (n3 < lFunction.constants.length) {
                stringBuilder.append(" = ");
                stringBuilder.append(lFunction.constants[n3].toPrintString(n | 2));
            } else {
                stringBuilder.append(" out of range");
            }
        }
        return stringBuilder.toString();
    }
}

