/*
 * Decompiled with CFR 0.152.
 */
package unluac.decompile;

import unluac.Version;
import unluac.decompile.CodeExtract;
import unluac.decompile.Constant;
import unluac.decompile.expression.ConstantExpression;
import unluac.decompile.expression.GlobalExpression;
import unluac.parse.LFunction;

public class Function {
    private Version version;
    private Constant[] constants;
    private final CodeExtract extract;

    public Function(LFunction lFunction) {
        this.version = lFunction.header.version;
        this.constants = new Constant[lFunction.constants.length];
        for (int i = 0; i < this.constants.length; ++i) {
            this.constants[i] = new Constant(lFunction.constants[i]);
        }
        this.extract = lFunction.header.extractor;
    }

    public boolean isConstant(int n) {
        return this.extract.is_k(n);
    }

    public int constantIndex(int n) {
        return this.extract.get_k(n);
    }

    public ConstantExpression getGlobalName(int n) {
        Constant constant = this.constants[n];
        if (!constant.isIdentifierPermissive(this.version)) {
            throw new IllegalStateException();
        }
        return new ConstantExpression(constant, true, n);
    }

    public ConstantExpression getConstantExpression(int n) {
        Constant constant = this.constants[n];
        return new ConstantExpression(constant, constant.isIdentifier(this.version), n);
    }

    public GlobalExpression getGlobalExpression(int n) {
        return new GlobalExpression(this.getGlobalName(n), n);
    }

    public Version getVersion() {
        return this.version;
    }
}

