/*
 * Decompiled with CFR 0.152.
 */
package unluac.decompile;

import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import unluac.decompile.OutputProvider;

public class FileOutputProvider
implements OutputProvider {
    private final OutputStream out;
    private final String eol;

    public FileOutputProvider(FileOutputStream fileOutputStream) {
        this.out = new BufferedOutputStream(fileOutputStream);
        this.eol = System.lineSeparator();
    }

    @Override
    public void print(String string) {
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c < '\u0000' || c > '\u00ff') {
                throw new IllegalStateException();
            }
            this.print((byte)c);
        }
    }

    @Override
    public void print(byte by) {
        try {
            this.out.write(by);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException.getMessage());
        }
    }

    @Override
    public void println() {
        this.print(this.eol);
    }

    @Override
    public void finish() {
        try {
            this.out.flush();
            this.out.close();
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException.getMessage());
        }
    }
}

