/*
 * Decompiled with CFR 0.152.
 */
package unluac.decompile;

import unluac.Version;
import unluac.assemble.Directive;
import unluac.decompile.Code;
import unluac.decompile.Op;
import unluac.decompile.OpcodeMap;
import unluac.decompile.Output;
import unluac.decompile.Type;
import unluac.decompile.TypeMap;
import unluac.parse.LAbsLineInfo;
import unluac.parse.LFunction;
import unluac.parse.LLocal;
import unluac.parse.LUpvalue;
import unluac.util.StringUtils;

public class Disassembler {
    private final LFunction function;
    private final Code code;
    private final String name;
    private final String parent;

    public Disassembler(LFunction lFunction) {
        this(lFunction, "main", null);
    }

    private Disassembler(LFunction lFunction, String string, String string2) {
        this.function = lFunction;
        this.code = new Code(lFunction);
        this.name = string;
        this.parent = string2;
    }

    public void disassemble(Output output) {
        this.disassemble(output, 0, 0);
    }

    private void disassemble(Output output, int n, int n2) {
        int n3;
        int n4;
        Object object222;
        Object object3;
        if (this.parent == null) {
            output.println(".version\t" + this.function.header.version.getName());
            output.println();
            for (Directive directive : this.function.header.lheader_type.get_directives()) {
                directive.disassemble(output, this.function.header, this.function.header.lheader);
            }
            output.println();
            if (this.function.header.typemap != this.function.header.version.getTypeMap()) {
                object3 = this.function.header.typemap;
                for (int i = 0; i < ((TypeMap)object3).size(); ++i) {
                    object222 = ((TypeMap)object3).get(i);
                    if (object222 == null) continue;
                    output.println(Directive.TYPE.token + "\t" + i + "\t" + ((Type)((Object)object222)).name);
                }
                output.println();
            }
            if (this.function.header.opmap != this.function.header.version.getOpcodeMap()) {
                object3 = this.function.header.opmap;
                for (int i = 0; i < ((OpcodeMap)object3).size(); ++i) {
                    object222 = ((OpcodeMap)object3).get(i);
                    if (object222 == null) continue;
                    output.println(Directive.OP.token + "\t" + i + "\t" + ((Op)((Object)object222)).name);
                }
                output.println();
            }
        }
        object3 = this.parent == null ? this.name : this.parent + "/" + this.name;
        output.println(".function\t" + (String)object3);
        output.println();
        for (Object object222 : this.function.header.function.get_directives()) {
            object222.disassemble(output, this.function.header, this.function, 1);
        }
        output.println();
        if (this.function.locals.length > 0) {
            for (int i = 1; i <= this.function.locals.length; ++i) {
                object222 = this.function.locals[i - 1];
                output.println(".local\t" + ((LLocal)object222).name.toPrintString(1) + "\t" + ((LLocal)object222).start + "\t" + ((LLocal)object222).end);
            }
            output.println();
        }
        if (this.function.upvalues.length > 0) {
            for (int i = 1; i <= this.function.upvalues.length; ++i) {
                object222 = this.function.upvalues[i - 1];
                output.println(".upvalue\t" + StringUtils.toPrintString(((LUpvalue)object222).name) + "\t" + ((LUpvalue)object222).idx + "\t" + ((LUpvalue)object222).instack);
            }
            output.println();
        }
        if (this.function.constants.length > 0) {
            for (int i = 1; i <= this.function.constants.length; ++i) {
                output.println(".constant\tk" + (i - 1) + "\t" + this.function.constants[i - 1].toPrintString(1));
            }
            output.println();
        }
        boolean[] blArray = new boolean[this.function.code.length];
        for (n4 = 1; n4 <= this.function.code.length; ++n4) {
            Op op = this.code.op(n4);
            if (op == null || !op.hasJump() || (n3 = this.code.target(n4)) < 1 || n3 > blArray.length) continue;
            blArray[n3 - 1] = true;
        }
        n4 = 0;
        int n5 = 0;
        for (n3 = 1; n3 <= this.function.code.length; ++n3) {
            int n6;
            if (blArray[n3 - 1]) {
                output.println(".label\tl" + n3);
            }
            if (this.function.abslineinfo != null && n4 < this.function.abslineinfo.length && this.function.abslineinfo[n4].pc == n3 - 1) {
                LAbsLineInfo lAbsLineInfo = this.function.abslineinfo[n4++];
                output.println(".abslineinfo\t" + lAbsLineInfo.pc + "\t" + lAbsLineInfo.line);
            }
            if (n3 <= this.function.lines.length) {
                output.print(".line\t" + this.function.lines[n3 - 1] + "\t");
            }
            Op object = this.code.op(n3);
            String string = null;
            if (object != null && object.hasJump() && (n6 = this.code.target(n3)) >= 1 && n6 <= this.code.length) {
                string = "l" + n6;
            }
            if (object == null) {
                output.println(Op.defaultToString(1, this.function, this.code.codepoint(n3), this.function.header.version, this.code.getExtractor(), n5 > 0));
            } else {
                output.println(object.codePointToString(1, this.function, this.code.codepoint(n3), this.code.getExtractor(), string, n5 > 0));
            }
            if (n5 > 0) {
                --n5;
                continue;
            }
            if (object != Op.CLOSURE || this.function.header.version.upvaluedeclarationtype.get() != Version.UpvalueDeclarationType.INLINE || (n6 = this.code.Bx(n3)) < 0 || n6 >= this.function.functions.length) continue;
            LFunction lFunction = this.function.functions[n6];
            if (lFunction.numUpvalues <= 0) continue;
            n5 = lFunction.numUpvalues;
        }
        for (n3 = this.function.code.length + 1; n3 <= this.function.lines.length; ++n3) {
            if (this.function.abslineinfo != null && n4 < this.function.abslineinfo.length && this.function.abslineinfo[n4].pc == n3 - 1) {
                LAbsLineInfo lAbsLineInfo = this.function.abslineinfo[n4++];
                output.println(".abslineinfo\t" + lAbsLineInfo.pc + "\t" + lAbsLineInfo.line);
            }
            output.println(".line\t" + this.function.lines[n3 - 1]);
        }
        if (this.function.abslineinfo != null) {
            while (n4 < this.function.abslineinfo.length) {
                LAbsLineInfo lAbsLineInfo = this.function.abslineinfo[n4++];
                output.println(".abslineinfo\t" + lAbsLineInfo.pc + "\t" + lAbsLineInfo.line);
            }
        }
        output.println();
        int n7 = 0;
        for (LFunction lFunction : this.function.functions) {
            new Disassembler(lFunction, "f" + n7, (String)object3).disassemble(output, n + 1, n7);
            ++n7;
        }
    }
}

