/*
 * Decompiled with CFR 0.152.
 */
package unluac.decompile;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import unluac.Configuration;
import unluac.Version;
import unluac.decompile.Code;
import unluac.decompile.ControlFlowHandler;
import unluac.decompile.Declaration;
import unluac.decompile.Function;
import unluac.decompile.Op;
import unluac.decompile.Output;
import unluac.decompile.OutputProvider;
import unluac.decompile.Registers;
import unluac.decompile.Upvalues;
import unluac.decompile.VariableFinder;
import unluac.decompile.Walker;
import unluac.decompile.block.Block;
import unluac.decompile.block.DoEndBlock;
import unluac.decompile.block.OuterBlock;
import unluac.decompile.expression.ClosureExpression;
import unluac.decompile.expression.ConstantExpression;
import unluac.decompile.expression.Expression;
import unluac.decompile.expression.FunctionCall;
import unluac.decompile.expression.TableLiteral;
import unluac.decompile.expression.TableReference;
import unluac.decompile.expression.Vararg;
import unluac.decompile.operation.CallOperation;
import unluac.decompile.operation.GlobalSet;
import unluac.decompile.operation.LoadNil;
import unluac.decompile.operation.MultipleRegisterSet;
import unluac.decompile.operation.Operation;
import unluac.decompile.operation.RegisterSet;
import unluac.decompile.operation.ReturnOperation;
import unluac.decompile.operation.TableSet;
import unluac.decompile.operation.UpvalueSet;
import unluac.decompile.statement.Assignment;
import unluac.decompile.statement.Label;
import unluac.decompile.statement.Statement;
import unluac.decompile.target.GlobalTarget;
import unluac.decompile.target.TableTarget;
import unluac.decompile.target.Target;
import unluac.decompile.target.UpvalueTarget;
import unluac.decompile.target.VariableTarget;
import unluac.parse.LFunction;
import unluac.parse.LUpvalue;
import unluac.util.Stack;

public class Decompiler {
    public final LFunction function;
    public final Code code;
    public final Declaration[] declList;
    private final int registers;
    private final int length;
    private final Upvalues upvalues;
    private final Function f;
    private final LFunction[] functions;
    private final int params;
    private final int vararg;

    public Decompiler(LFunction lFunction) {
        this(lFunction, null, -1);
    }

    public Decompiler(LFunction lFunction, Declaration[] declarationArray, int n) {
        this.f = new Function(lFunction);
        this.function = lFunction;
        this.registers = lFunction.maximumStackSize;
        this.length = lFunction.code.length;
        this.code = new Code(lFunction);
        if (lFunction.stripped || this.getConfiguration().variable == Configuration.VariableMode.NODEBUG) {
            if (this.getConfiguration().variable == Configuration.VariableMode.FINDER) {
                this.declList = VariableFinder.process(this, lFunction.numParams, lFunction.maximumStackSize);
            } else {
                int n2;
                this.declList = new Declaration[lFunction.maximumStackSize];
                int n3 = this.length + lFunction.header.version.outerblockscopeadjustment.get();
                for (n2 = 0; n2 < Math.min(lFunction.numParams, lFunction.maximumStackSize); ++n2) {
                    this.declList[n2] = new Declaration("A" + n2 + "_" + lFunction.level, 0, n3);
                }
                if (this.getVersion().varargtype.get() != Version.VarArgType.ELLIPSIS && (lFunction.vararg & 1) != 0 && n2 < lFunction.maximumStackSize) {
                    this.declList[n2++] = new Declaration("arg", 0, n3);
                }
                while (n2 < lFunction.maximumStackSize) {
                    this.declList[n2] = new Declaration("L" + n2 + "_" + lFunction.level, 0, n3);
                    ++n2;
                }
            }
        } else if (lFunction.locals.length >= lFunction.numParams) {
            this.declList = new Declaration[lFunction.locals.length];
            for (int i = 0; i < this.declList.length; ++i) {
                this.declList[i] = new Declaration(lFunction.locals[i], this.code);
            }
        } else {
            this.declList = new Declaration[lFunction.numParams];
            for (int i = 0; i < this.declList.length; ++i) {
                this.declList[i] = new Declaration("_ARG_" + i + "_", 0, this.length - 1);
            }
        }
        this.upvalues = new Upvalues(lFunction, declarationArray, n);
        this.functions = lFunction.functions;
        this.params = lFunction.numParams;
        this.vararg = lFunction.vararg;
    }

    public Configuration getConfiguration() {
        return this.function.header.config;
    }

    public Version getVersion() {
        return this.function.header.version;
    }

    public boolean getNoDebug() {
        return this.function.header.config.variable == Configuration.VariableMode.NODEBUG || this.function.stripped && this.function.header.config.variable == Configuration.VariableMode.DEFAULT;
    }

    public State decompile() {
        State state = new State();
        state.r = new Registers(this.registers, this.length, this.declList, this.f, this.getNoDebug());
        ControlFlowHandler.Result result = ControlFlowHandler.process(this, state.r);
        List<Block> list = result.blocks;
        state.outer = list.get(0);
        state.flags = new byte[this.code.length + 1];
        for (int i = 1; i <= this.code.length; ++i) {
            if (!result.labels[i]) continue;
            int n = i;
            state.flags[n] = (byte)(state.flags[n] | Flag.LABELS.bit);
        }
        this.processSequence(state, list, 1, this.code.length);
        for (Block block : list) {
            block.resolve(state.r);
        }
        this.handleUnusedConstants(state.outer);
        return state;
    }

    public void print(State state) {
        this.print(state, new Output());
    }

    public void print(State state, OutputProvider outputProvider) {
        this.print(state, new Output(outputProvider));
    }

    public void print(State state, Output output) {
        this.handleInitialDeclares(output);
        state.outer.print(this, output);
    }

    private void handleUnusedConstants(Block block) {
        final HashSet hashSet = new HashSet(this.function.constants.length);
        block.walk(new Walker(this){
            private int nextConstant = 0;

            @Override
            public void visitExpression(Expression expression) {
                int n;
                if (expression.isConstant() && (n = expression.getConstantIndex()) >= 0) {
                    while (n > this.nextConstant) {
                        hashSet.add(this.nextConstant++);
                    }
                    if (n == this.nextConstant) {
                        ++this.nextConstant;
                    }
                }
            }
        });
        block.walk(new Walker(){
            private int nextConstant = 0;

            @Override
            public void visitStatement(Statement statement) {
                if (hashSet.contains(this.nextConstant) && statement.useConstant(Decompiler.this.f, this.nextConstant)) {
                    ++this.nextConstant;
                }
            }

            @Override
            public void visitExpression(Expression expression) {
                int n;
                if (expression.isConstant() && (n = expression.getConstantIndex()) >= this.nextConstant) {
                    this.nextConstant = n + 1;
                }
            }
        });
    }

    private void handleInitialDeclares(Output output) {
        int n;
        ArrayList<Declaration> arrayList = new ArrayList<Declaration>(this.declList.length);
        int n2 = this.params;
        switch (this.getVersion().varargtype.get()) {
            case ARG: 
            case HYBRID: {
                n2 += this.vararg & 1;
                break;
            }
        }
        for (n = n2; n < this.declList.length; ++n) {
            if (this.declList[n].begin != 0) continue;
            arrayList.add(this.declList[n]);
        }
        if (arrayList.size() > 0) {
            output.print("local ");
            output.print(((Declaration)arrayList.get((int)0)).name);
            for (n = 1; n < arrayList.size(); ++n) {
                output.print(", ");
                output.print(((Declaration)arrayList.get((int)n)).name);
            }
            output.println();
        }
    }

    private int fb2int50(int n) {
        return (n & 7) << (n >> 3);
    }

    private int fb2int(int n) {
        int n2 = n >> 3 & 0x1F;
        if (n2 == 0) {
            return n;
        }
        return (n & 7) + 8 << n2 - 1;
    }

    private Expression.BinaryOperation decodeBinOp(int n) {
        switch (n) {
            case 6: {
                return Expression.BinaryOperation.ADD;
            }
            case 7: {
                return Expression.BinaryOperation.SUB;
            }
            case 8: {
                return Expression.BinaryOperation.MUL;
            }
            case 9: {
                return Expression.BinaryOperation.MOD;
            }
            case 10: {
                return Expression.BinaryOperation.POW;
            }
            case 11: {
                return Expression.BinaryOperation.DIV;
            }
            case 12: {
                return Expression.BinaryOperation.IDIV;
            }
            case 13: {
                return Expression.BinaryOperation.BAND;
            }
            case 14: {
                return Expression.BinaryOperation.BOR;
            }
            case 15: {
                return Expression.BinaryOperation.BXOR;
            }
            case 16: {
                return Expression.BinaryOperation.SHL;
            }
            case 17: {
                return Expression.BinaryOperation.SHR;
            }
        }
        throw new IllegalStateException();
    }

    private void handle50BinOp(List<Operation> list, State state, int n, Expression.BinaryOperation binaryOperation) {
        list.add(new RegisterSet(n, this.code.A(n), Expression.make(binaryOperation, state.r.getKExpression(this.code.B(n), n), state.r.getKExpression(this.code.C(n), n))));
    }

    private void handle54BinOp(List<Operation> list, State state, int n, Expression.BinaryOperation binaryOperation) {
        list.add(new RegisterSet(n, this.code.A(n), Expression.make(binaryOperation, state.r.getExpression(this.code.B(n), n), state.r.getExpression(this.code.C(n), n))));
    }

    private void handle54BinKOp(List<Operation> list, State state, int n, Expression.BinaryOperation binaryOperation) {
        if (n + 1 > this.code.length || this.code.op(n + 1) != Op.MMBINK) {
            throw new IllegalStateException();
        }
        Expression expression = state.r.getExpression(this.code.B(n), n);
        Expression expression2 = this.f.getConstantExpression(this.code.C(n));
        if (this.code.k(n + 1)) {
            Expression expression3 = expression;
            expression = expression2;
            expression2 = expression3;
        }
        list.add(new RegisterSet(n, this.code.A(n), Expression.make(binaryOperation, expression, expression2)));
    }

    private void handleUnaryOp(List<Operation> list, State state, int n, Expression.UnaryOperation unaryOperation) {
        list.add(new RegisterSet(n, this.code.A(n), Expression.make(unaryOperation, state.r.getExpression(this.code.B(n), n))));
    }

    private void handleSetList(List<Operation> list, State state, int n, int n2, int n3, int n4) {
        Expression expression = state.r.getValue(n2, n);
        for (int i = 1; i <= n3; ++i) {
            list.add(new TableSet(n, expression, ConstantExpression.createInteger(n4 + i), state.r.getExpression(n2 + i, n), false, state.r.getUpdated(n2 + i, n)));
        }
    }

    private List<Operation> processLine(State state, int n) {
        Registers registers = state.r;
        byte[] byArray = state.flags;
        LinkedList<Operation> linkedList = new LinkedList<Operation>();
        int n2 = this.code.A(n);
        int n3 = this.code.B(n);
        int n4 = this.code.C(n);
        int n5 = this.code.Bx(n);
        switch (this.code.op(n)) {
            case MOVE: {
                linkedList.add(new RegisterSet(n, n2, registers.getExpression(n3, n)));
                break;
            }
            case LOADI: {
                linkedList.add(new RegisterSet(n, n2, ConstantExpression.createInteger(this.code.sBx(n))));
                break;
            }
            case LOADF: {
                linkedList.add(new RegisterSet(n, n2, ConstantExpression.createDouble(this.code.sBx(n))));
                break;
            }
            case LOADK: {
                linkedList.add(new RegisterSet(n, n2, this.f.getConstantExpression(n5)));
                break;
            }
            case LOADKX: {
                if (n + 1 > this.code.length || this.code.op(n + 1) != Op.EXTRAARG) {
                    throw new IllegalStateException();
                }
                linkedList.add(new RegisterSet(n, n2, this.f.getConstantExpression(this.code.Ax(n + 1))));
                break;
            }
            case LOADBOOL: {
                linkedList.add(new RegisterSet(n, n2, ConstantExpression.createBoolean(n3 != 0)));
                break;
            }
            case LOADFALSE: 
            case LFALSESKIP: {
                linkedList.add(new RegisterSet(n, n2, ConstantExpression.createBoolean(false)));
                break;
            }
            case LOADTRUE: {
                linkedList.add(new RegisterSet(n, n2, ConstantExpression.createBoolean(true)));
                break;
            }
            case LOADNIL: {
                linkedList.add(new LoadNil(n, n2, n3));
                break;
            }
            case LOADNIL52: {
                linkedList.add(new LoadNil(n, n2, n2 + n3));
                break;
            }
            case GETGLOBAL: {
                linkedList.add(new RegisterSet(n, n2, this.f.getGlobalExpression(n5)));
                break;
            }
            case SETGLOBAL: {
                linkedList.add(new GlobalSet(n, this.f.getGlobalName(n5), registers.getExpression(n2, n)));
                break;
            }
            case GETUPVAL: {
                linkedList.add(new RegisterSet(n, n2, this.upvalues.getExpression(n3)));
                break;
            }
            case SETUPVAL: {
                linkedList.add(new UpvalueSet(n, this.upvalues.getName(n3), registers.getExpression(n2, n)));
                break;
            }
            case GETTABUP: {
                linkedList.add(new RegisterSet(n, n2, new TableReference(this.upvalues.getExpression(n3), registers.getKExpression(n4, n))));
                break;
            }
            case GETTABUP54: {
                linkedList.add(new RegisterSet(n, n2, new TableReference(this.upvalues.getExpression(n3), this.f.getConstantExpression(n4))));
                break;
            }
            case GETTABLE: {
                linkedList.add(new RegisterSet(n, n2, new TableReference(registers.getExpression(n3, n), registers.getKExpression(n4, n))));
                break;
            }
            case GETTABLE54: {
                linkedList.add(new RegisterSet(n, n2, new TableReference(registers.getExpression(n3, n), registers.getExpression(n4, n))));
                break;
            }
            case GETI: {
                linkedList.add(new RegisterSet(n, n2, new TableReference(registers.getExpression(n3, n), ConstantExpression.createInteger(n4))));
                break;
            }
            case GETFIELD: {
                linkedList.add(new RegisterSet(n, n2, new TableReference(registers.getExpression(n3, n), this.f.getConstantExpression(n4))));
                break;
            }
            case SETTABLE: {
                linkedList.add(new TableSet(n, registers.getExpression(n2, n), registers.getKExpression(n3, n), registers.getKExpression(n4, n), true, n));
                break;
            }
            case SETTABLE54: {
                linkedList.add(new TableSet(n, registers.getExpression(n2, n), registers.getExpression(n3, n), registers.getKExpression54(n4, this.code.k(n), n), true, n));
                break;
            }
            case SETI: {
                linkedList.add(new TableSet(n, registers.getExpression(n2, n), ConstantExpression.createInteger(n3), registers.getKExpression54(n4, this.code.k(n), n), true, n));
                break;
            }
            case SETFIELD: {
                linkedList.add(new TableSet(n, registers.getExpression(n2, n), this.f.getConstantExpression(n3), registers.getKExpression54(n4, this.code.k(n), n), true, n));
                break;
            }
            case SETTABUP: {
                linkedList.add(new TableSet(n, this.upvalues.getExpression(n2), registers.getKExpression(n3, n), registers.getKExpression(n4, n), true, n));
                break;
            }
            case SETTABUP54: {
                linkedList.add(new TableSet(n, this.upvalues.getExpression(n2), this.f.getConstantExpression(n3), registers.getKExpression54(n4, this.code.k(n), n), true, n));
                break;
            }
            case NEWTABLE50: {
                linkedList.add(new RegisterSet(n, n2, new TableLiteral(this.fb2int50(n3), n4 == 0 ? 0 : 1 << n4)));
                break;
            }
            case NEWTABLE: {
                linkedList.add(new RegisterSet(n, n2, new TableLiteral(this.fb2int(n3), this.fb2int(n4))));
                break;
            }
            case NEWTABLE54: {
                if (this.code.op(n + 1) != Op.EXTRAARG) {
                    throw new IllegalStateException();
                }
                int n6 = n4;
                if (this.code.k(n)) {
                    n6 += this.code.Ax(n + 1) * (this.code.getExtractor().C.max() + 1);
                }
                linkedList.add(new RegisterSet(n, n2, new TableLiteral(n6, n3 == 0 ? 0 : 1 << n3 - 1)));
                break;
            }
            case SELF: {
                Expression expression = registers.getExpression(n3, n);
                linkedList.add(new RegisterSet(n, n2 + 1, expression));
                linkedList.add(new RegisterSet(n, n2, new TableReference(expression, registers.getKExpression(n4, n))));
                break;
            }
            case SELF54: {
                Expression expression = registers.getExpression(n3, n);
                linkedList.add(new RegisterSet(n, n2 + 1, expression));
                linkedList.add(new RegisterSet(n, n2, new TableReference(expression, registers.getKExpression54(n4, this.code.k(n), n))));
                break;
            }
            case ADD: {
                this.handle50BinOp(linkedList, state, n, Expression.BinaryOperation.ADD);
                break;
            }
            case SUB: {
                this.handle50BinOp(linkedList, state, n, Expression.BinaryOperation.SUB);
                break;
            }
            case MUL: {
                this.handle50BinOp(linkedList, state, n, Expression.BinaryOperation.MUL);
                break;
            }
            case DIV: {
                this.handle50BinOp(linkedList, state, n, Expression.BinaryOperation.DIV);
                break;
            }
            case IDIV: {
                this.handle50BinOp(linkedList, state, n, Expression.BinaryOperation.IDIV);
                break;
            }
            case MOD: {
                this.handle50BinOp(linkedList, state, n, Expression.BinaryOperation.MOD);
                break;
            }
            case POW: {
                this.handle50BinOp(linkedList, state, n, Expression.BinaryOperation.POW);
                break;
            }
            case BAND: {
                this.handle50BinOp(linkedList, state, n, Expression.BinaryOperation.BAND);
                break;
            }
            case BOR: {
                this.handle50BinOp(linkedList, state, n, Expression.BinaryOperation.BOR);
                break;
            }
            case BXOR: {
                this.handle50BinOp(linkedList, state, n, Expression.BinaryOperation.BXOR);
                break;
            }
            case SHL: {
                this.handle50BinOp(linkedList, state, n, Expression.BinaryOperation.SHL);
                break;
            }
            case SHR: {
                this.handle50BinOp(linkedList, state, n, Expression.BinaryOperation.SHR);
                break;
            }
            case ADD54: {
                this.handle54BinOp(linkedList, state, n, Expression.BinaryOperation.ADD);
                break;
            }
            case SUB54: {
                this.handle54BinOp(linkedList, state, n, Expression.BinaryOperation.SUB);
                break;
            }
            case MUL54: {
                this.handle54BinOp(linkedList, state, n, Expression.BinaryOperation.MUL);
                break;
            }
            case DIV54: {
                this.handle54BinOp(linkedList, state, n, Expression.BinaryOperation.DIV);
                break;
            }
            case IDIV54: {
                this.handle54BinOp(linkedList, state, n, Expression.BinaryOperation.IDIV);
                break;
            }
            case MOD54: {
                this.handle54BinOp(linkedList, state, n, Expression.BinaryOperation.MOD);
                break;
            }
            case POW54: {
                this.handle54BinOp(linkedList, state, n, Expression.BinaryOperation.POW);
                break;
            }
            case BAND54: {
                this.handle54BinOp(linkedList, state, n, Expression.BinaryOperation.BAND);
                break;
            }
            case BOR54: {
                this.handle54BinOp(linkedList, state, n, Expression.BinaryOperation.BOR);
                break;
            }
            case BXOR54: {
                this.handle54BinOp(linkedList, state, n, Expression.BinaryOperation.BXOR);
                break;
            }
            case SHL54: {
                this.handle54BinOp(linkedList, state, n, Expression.BinaryOperation.SHL);
                break;
            }
            case SHR54: {
                this.handle54BinOp(linkedList, state, n, Expression.BinaryOperation.SHR);
                break;
            }
            case ADDI: {
                if (n + 1 > this.code.length || this.code.op(n + 1) != Op.MMBINI) {
                    throw new IllegalStateException();
                }
                Expression.BinaryOperation binaryOperation = this.decodeBinOp(this.code.C(n + 1));
                int n7 = this.code.sC(n);
                boolean bl = false;
                if (this.code.k(n + 1)) {
                    if (binaryOperation != Expression.BinaryOperation.ADD) {
                        throw new IllegalStateException();
                    }
                    bl = true;
                } else if (binaryOperation != Expression.BinaryOperation.ADD) {
                    if (binaryOperation == Expression.BinaryOperation.SUB) {
                        n7 = -n7;
                    } else {
                        throw new IllegalStateException();
                    }
                }
                Expression expression = registers.getExpression(n3, n);
                Expression expression2 = ConstantExpression.createInteger(n7);
                if (bl) {
                    Expression expression3 = expression;
                    expression = expression2;
                    expression2 = expression3;
                }
                linkedList.add(new RegisterSet(n, n2, Expression.make(binaryOperation, expression, expression2)));
                break;
            }
            case ADDK: {
                this.handle54BinKOp(linkedList, state, n, Expression.BinaryOperation.ADD);
                break;
            }
            case SUBK: {
                this.handle54BinKOp(linkedList, state, n, Expression.BinaryOperation.SUB);
                break;
            }
            case MULK: {
                this.handle54BinKOp(linkedList, state, n, Expression.BinaryOperation.MUL);
                break;
            }
            case DIVK: {
                this.handle54BinKOp(linkedList, state, n, Expression.BinaryOperation.DIV);
                break;
            }
            case IDIVK: {
                this.handle54BinKOp(linkedList, state, n, Expression.BinaryOperation.IDIV);
                break;
            }
            case MODK: {
                this.handle54BinKOp(linkedList, state, n, Expression.BinaryOperation.MOD);
                break;
            }
            case POWK: {
                this.handle54BinKOp(linkedList, state, n, Expression.BinaryOperation.POW);
                break;
            }
            case BANDK: {
                this.handle54BinKOp(linkedList, state, n, Expression.BinaryOperation.BAND);
                break;
            }
            case BORK: {
                this.handle54BinKOp(linkedList, state, n, Expression.BinaryOperation.BOR);
                break;
            }
            case BXORK: {
                this.handle54BinKOp(linkedList, state, n, Expression.BinaryOperation.BXOR);
                break;
            }
            case SHRI: {
                if (n + 1 > this.code.length || this.code.op(n + 1) != Op.MMBINI) {
                    throw new IllegalStateException();
                }
                int n8 = this.code.sC(n);
                Expression.BinaryOperation binaryOperation = this.decodeBinOp(this.code.C(n + 1));
                if (binaryOperation != Expression.BinaryOperation.SHR) {
                    if (binaryOperation == Expression.BinaryOperation.SHL) {
                        n8 = -n8;
                    } else {
                        throw new IllegalStateException();
                    }
                }
                linkedList.add(new RegisterSet(n, n2, Expression.make(binaryOperation, registers.getExpression(n3, n), ConstantExpression.createInteger(n8))));
                break;
            }
            case SHLI: {
                linkedList.add(new RegisterSet(n, n2, Expression.make(Expression.BinaryOperation.SHL, ConstantExpression.createInteger(this.code.sC(n)), registers.getExpression(n3, n))));
                break;
            }
            case MMBIN: 
            case MMBINI: 
            case MMBINK: {
                break;
            }
            case UNM: {
                this.handleUnaryOp(linkedList, state, n, Expression.UnaryOperation.UNM);
                break;
            }
            case NOT: {
                this.handleUnaryOp(linkedList, state, n, Expression.UnaryOperation.NOT);
                break;
            }
            case LEN: {
                this.handleUnaryOp(linkedList, state, n, Expression.UnaryOperation.LEN);
                break;
            }
            case BNOT: {
                this.handleUnaryOp(linkedList, state, n, Expression.UnaryOperation.BNOT);
                break;
            }
            case CONCAT: {
                Expression expression = registers.getExpression(n4, n);
                while (n4-- > n3) {
                    expression = Expression.make(Expression.BinaryOperation.CONCAT, registers.getExpression(n4, n), expression);
                }
                linkedList.add(new RegisterSet(n, n2, expression));
                break;
            }
            case CONCAT54: {
                if (n3 < 2) {
                    throw new IllegalStateException();
                }
                Expression expression = registers.getExpression(n2 + --n3, n);
                while (n3-- > 0) {
                    expression = Expression.make(Expression.BinaryOperation.CONCAT, registers.getExpression(n2 + n3, n), expression);
                }
                linkedList.add(new RegisterSet(n, n2, expression));
                break;
            }
            case JMP: 
            case JMP52: 
            case JMP54: 
            case EQ: 
            case LT: 
            case LE: 
            case EQ54: 
            case LT54: 
            case LE54: 
            case EQK: 
            case EQI: 
            case LTI: 
            case LEI: 
            case GTI: 
            case GEI: 
            case TEST: 
            case TEST54: {
                break;
            }
            case TEST50: {
                if (!this.getNoDebug() || n2 == n3) break;
                linkedList.add(new RegisterSet(n, n2, Expression.make(Expression.BinaryOperation.OR, registers.getExpression(n3, n), this.initialExpression(state, n2, n))));
                break;
            }
            case TESTSET: 
            case TESTSET54: {
                if (!this.getNoDebug()) break;
                linkedList.add(new RegisterSet(n, n2, Expression.make(Expression.BinaryOperation.OR, registers.getExpression(n3, n), this.initialExpression(state, n2, n))));
                break;
            }
            case CALL: {
                boolean bl;
                boolean bl2 = bl = n4 >= 3 || n4 == 0;
                if (n3 == 0) {
                    n3 = this.registers - n2;
                }
                if (n4 == 0) {
                    n4 = this.registers - n2 + 1;
                }
                Expression expression = registers.getExpression(n2, n);
                Expression[] expressionArray = new Expression[n3 - 1];
                for (int i = n2 + 1; i <= n2 + n3 - 1; ++i) {
                    expressionArray[i - n2 - 1] = registers.getExpression(i, n);
                }
                FunctionCall functionCall = new FunctionCall(expression, expressionArray, bl);
                if (n4 == 1 && (n2 <= 0 || registers.isLocal(n2 - 1, n) && !registers.isNewLocal(n2 - 1, n))) {
                    linkedList.add(new CallOperation(n, functionCall));
                    break;
                }
                if (n4 == 1) {
                    n4 = 2;
                }
                if (n4 == 2 && !bl) {
                    linkedList.add(new RegisterSet(n, n2, functionCall));
                    break;
                }
                linkedList.add(new MultipleRegisterSet(n, n2, n2 + n4 - 2, functionCall));
                break;
            }
            case TAILCALL: 
            case TAILCALL54: {
                if (n3 == 0) {
                    n3 = this.registers - n2;
                }
                Expression expression = registers.getExpression(n2, n);
                Expression[] expressionArray = new Expression[n3 - 1];
                for (int i = n2 + 1; i <= n2 + n3 - 1; ++i) {
                    expressionArray[i - n2 - 1] = registers.getExpression(i, n);
                }
                FunctionCall functionCall = new FunctionCall(expression, expressionArray, true);
                linkedList.add(new ReturnOperation(n, functionCall));
                int n9 = n + 1;
                byArray[n9] = (byte)(byArray[n9] | Flag.SKIP.bit);
                break;
            }
            case RETURN: 
            case RETURN54: {
                if (n3 == 0) {
                    n3 = this.registers - n2 + 1;
                }
                Expression[] expressionArray = new Expression[n3 - 1];
                for (int i = n2; i <= n2 + n3 - 2; ++i) {
                    expressionArray[i - n2] = registers.getExpression(i, n);
                }
                linkedList.add(new ReturnOperation(n, expressionArray));
                break;
            }
            case RETURN0: {
                linkedList.add(new ReturnOperation(n, new Expression[0]));
                break;
            }
            case RETURN1: {
                linkedList.add(new ReturnOperation(n, new Expression[]{registers.getExpression(n2, n)}));
                break;
            }
            case FORLOOP: 
            case FORLOOP54: 
            case FORPREP: 
            case FORPREP54: 
            case TFORPREP: 
            case TFORPREP54: 
            case TFORCALL: 
            case TFORCALL54: 
            case TFORLOOP: 
            case TFORLOOP52: 
            case TFORLOOP54: {
                break;
            }
            case SETLIST50: {
                this.handleSetList(linkedList, state, n, n2, 1 + n5 % 32, n5 - n5 % 32);
                break;
            }
            case SETLISTO: {
                this.handleSetList(linkedList, state, n, n2, this.registers - n2 - 1, n5 - n5 % 32);
                break;
            }
            case SETLIST: {
                if (n4 == 0) {
                    n4 = this.code.codepoint(n + 1);
                    int n10 = n + 1;
                    byArray[n10] = (byte)(byArray[n10] | Flag.SKIP.bit);
                }
                if (n3 == 0) {
                    n3 = this.registers - n2 - 1;
                }
                this.handleSetList(linkedList, state, n, n2, n3, (n4 - 1) * 50);
                break;
            }
            case SETLIST52: {
                if (n4 == 0) {
                    if (n + 1 > this.code.length || this.code.op(n + 1) != Op.EXTRAARG) {
                        throw new IllegalStateException();
                    }
                    n4 = this.code.Ax(n + 1);
                    int n11 = n + 1;
                    byArray[n11] = (byte)(byArray[n11] | Flag.SKIP.bit);
                }
                if (n3 == 0) {
                    n3 = this.registers - n2 - 1;
                }
                this.handleSetList(linkedList, state, n, n2, n3, (n4 - 1) * 50);
                break;
            }
            case SETLIST54: {
                if (this.code.k(n)) {
                    if (n + 1 > this.code.length || this.code.op(n + 1) != Op.EXTRAARG) {
                        throw new IllegalStateException();
                    }
                    n4 += this.code.Ax(n + 1) * (this.code.getExtractor().C.max() + 1);
                    int n12 = n + 1;
                    byArray[n12] = (byte)(byArray[n12] | Flag.SKIP.bit);
                }
                if (n3 == 0) {
                    n3 = this.registers - n2 - 1;
                }
                this.handleSetList(linkedList, state, n, n2, n3, n4);
                break;
            }
            case TBC: {
                registers.getDeclaration((int)n2, (int)n).tbc = true;
                break;
            }
            case CLOSE: {
                break;
            }
            case CLOSURE: {
                LFunction lFunction = this.functions[n5];
                linkedList.add(new RegisterSet(n, n2, new ClosureExpression(lFunction, n + 1)));
                if (this.function.header.version.upvaluedeclarationtype.get() != Version.UpvalueDeclarationType.INLINE) break;
                for (int i = 0; i < lFunction.numUpvalues; ++i) {
                    LUpvalue lUpvalue = lFunction.upvalues[i];
                    switch (this.code.op(n + 1 + i)) {
                        case MOVE: {
                            lUpvalue.instack = true;
                            break;
                        }
                        case GETUPVAL: {
                            lUpvalue.instack = false;
                            break;
                        }
                        default: {
                            throw new IllegalStateException();
                        }
                    }
                    lUpvalue.idx = this.code.B(n + 1 + i);
                    int n13 = n + 1 + i;
                    byArray[n13] = (byte)(byArray[n13] | Flag.SKIP.bit);
                }
                break;
            }
            case VARARGPREP: {
                break;
            }
            case VARARG: {
                boolean bl;
                boolean bl3 = bl = n3 != 2;
                if (n3 == 1) {
                    n3 = 2;
                }
                if (n3 == 0) {
                    n3 = this.registers - n2 + 1;
                }
                Vararg vararg = new Vararg(n3 - 1, bl);
                linkedList.add(new MultipleRegisterSet(n, n2, n2 + n3 - 2, vararg));
                break;
            }
            case VARARG54: {
                boolean bl;
                boolean bl4 = bl = n4 != 2;
                if (n4 == 1) {
                    n4 = 2;
                }
                if (n4 == 0) {
                    n4 = this.registers - n2 + 1;
                }
                Vararg vararg = new Vararg(n4 - 1, bl);
                linkedList.add(new MultipleRegisterSet(n, n2, n2 + n4 - 2, vararg));
                break;
            }
            case EXTRAARG: 
            case EXTRABYTE: {
                break;
            }
            case DEFAULT: 
            case DEFAULT54: {
                throw new IllegalStateException();
            }
        }
        return linkedList;
    }

    private Expression initialExpression(State state, int n, int n2) {
        if (n2 == 1) {
            if (n < this.function.numParams) {
                throw new IllegalStateException();
            }
            return ConstantExpression.createNil(n2);
        }
        return state.r.getExpression(n, n2 - 1);
    }

    private Assignment processOperation(State state, Operation operation, int n, int n2, Block block) {
        Registers registers = state.r;
        byte[] byArray = state.flags;
        Assignment assignment = null;
        List<Statement> list = operation.process(registers, block);
        if (list.size() == 1) {
            Statement statement = list.get(0);
            if (statement instanceof Assignment) {
                assignment = (Assignment)statement;
            }
            if (assignment != null) {
                boolean bl = false;
                for (Declaration object2 : registers.getNewLocals(n, block.closeRegister)) {
                    if (!assignment.getFirstTarget().isDeclaration(object2)) continue;
                    bl = true;
                    break;
                }
                while (!bl && n2 < block.end) {
                    Object object = this.code.op(n2);
                    if (this.isMoveIntoTarget(registers, n2)) {
                        Target target = this.getMoveIntoTargetTarget(registers, n2, n + 1);
                        Expression expression = this.getMoveIntoTargetValue(registers, n2, n + 1);
                        assignment.addFirst(target, expression, n2);
                        int n3 = n2++;
                        byArray[n3] = (byte)(byArray[n3] | Flag.SKIP.bit);
                        continue;
                    }
                    if (object != Op.MMBIN && object != Op.MMBINI && object != Op.MMBINK && !this.code.isUpvalueDeclaration(n2)) break;
                    ++n2;
                }
                if (n >= 2 && this.isMoveIntoTarget(registers, n)) {
                    int n4 = this.getMoveIntoTargetValueRegister(registers, n, n);
                    int n5 = this.getRegister(n - 1);
                    if (!registers.isLocal(n5, n - 1)) {
                        while (n4 < n5) {
                            assignment.addExcessValue(registers.getValue(++n4, n), registers.getUpdated(n4, n), n4);
                        }
                    }
                }
            }
        }
        for (Statement statement : list) {
            block.addStatement(statement);
        }
        return assignment;
    }

    public boolean hasStatement(int n, int n2) {
        if (n <= n2) {
            State state = new State();
            state.r = new Registers(this.registers, this.length, this.declList, this.f, this.getNoDebug());
            state.outer = new OuterBlock(this.function, this.code.length);
            DoEndBlock doEndBlock = new DoEndBlock(this.function, n, n2 + 1);
            state.flags = new byte[this.code.length + 1];
            List<Block> list = Arrays.asList(state.outer, doEndBlock);
            this.processSequence(state, list, 1, this.code.length);
            return !((Block)doEndBlock).isEmpty();
        }
        return false;
    }

    private void processSequence(State state, List<Block> list, int n, int n2) {
        Registers registers = state.r;
        int n3 = 0;
        int n4 = 0;
        ArrayList<Block> arrayList = new ArrayList<Block>(list.size());
        ArrayList<Block> arrayList2 = new ArrayList<Block>(list.size());
        for (Block object2 : list) {
            if (object2.isContainer()) {
                arrayList.add(object2);
                continue;
            }
            arrayList2.add(object2);
        }
        Stack stack = new Stack();
        stack.push((Block)arrayList.get(n3++));
        byte[] byArray = state.flags;
        boolean[] blArray = new boolean[this.code.length + 1];
        int n5 = 1;
        while (true) {
            Object bl;
            Object object;
            Object object2;
            Object object3;
            int n6 = n5;
            List<Operation> list2 = null;
            List<Declaration> list3 = null;
            List<Declaration> list4 = null;
            if (((Block)stack.peek()).end <= n5) {
                object3 = (Block)stack.pop();
                object2 = ((Block)object3).process(this);
                if (stack.isEmpty()) {
                    return;
                }
                if (object2 == null) {
                    throw new IllegalStateException();
                }
                list2 = Arrays.asList(object2);
                list3 = registers.getNewLocals(n5 - 1);
            } else {
                object3 = registers.getNewLocals(n5, ((Block)stack.peek()).closeRegister);
                while (n3 < arrayList.size() && ((Block)arrayList.get((int)n3)).begin <= n5) {
                    object2 = (Block)arrayList.get(n3++);
                    if (!object3.isEmpty() && ((Block)object2).allowsPreDeclare() && (((Declaration)object3.get((int)0)).end > ((Block)object2).scopeEnd() || ((Declaration)object3.get((int)0)).register < ((Block)object2).closeRegister)) {
                        object = new Assignment();
                        int operation = ((Declaration)object3.get((int)0)).end;
                        ((Assignment)object).declare(((Declaration)object3.get((int)0)).begin);
                        while (!(object3.isEmpty() || ((Declaration)object3.get((int)0)).end != operation || ((Block)object2).closeRegister != -1 && ((Declaration)object3.get((int)0)).register >= ((Block)object2).closeRegister)) {
                            bl = (Declaration)object3.get(0);
                            ((Assignment)object).addLast(new VariableTarget((Declaration)bl), ConstantExpression.createNil(n5), n5);
                            object3.remove(0);
                        }
                        ((Block)stack.peek()).addStatement((Statement)object);
                    }
                    if (!((Block)object2).hasHeader() && !blArray[n5] && (byArray[n5] & Flag.LABELS.bit) != 0) {
                        ((Block)stack.peek()).addStatement(new Label(n5));
                        blArray[n5] = true;
                    }
                    stack.push(object2);
                }
                if (!blArray[n5] && (byArray[n5] & Flag.LABELS.bit) != 0) {
                    ((Block)stack.peek()).addStatement(new Label(n5));
                    blArray[n5] = true;
                }
            }
            object3 = (Block)stack.peek();
            registers.startLine(n5);
            if (list2 == null) {
                if (n4 < arrayList2.size() && ((Block)arrayList2.get((int)n4)).begin <= n5) {
                    object2 = (Block)arrayList2.get(n4++);
                    object = ((Block)object2).process(this);
                    list2 = Arrays.asList(object);
                } else {
                    n6 = n5 + 1;
                    list2 = (byArray[n5] & Flag.SKIP.bit) == 0 && n5 >= n && n5 <= n2 ? this.processLine(state, n5) : Collections.emptyList();
                    if (n5 >= n && n5 <= n2) {
                        list4 = registers.getNewLocals(n5, ((Block)object3).closeRegister);
                    }
                }
            }
            object2 = null;
            for (Operation n8 : list2) {
                bl = this.processOperation(state, n8, n5, n6, (Block)object3);
                if (bl == null) continue;
                object2 = bl;
            }
            object = list4;
            if (object2 != null && list3 != null) {
                object = list3;
            }
            if (object != null && !object.isEmpty()) {
                int n7 = -1;
                if (object2 == null) {
                    object2 = new Assignment();
                    ((Block)object3).addStatement((Statement)object2);
                } else {
                    bl = object.iterator();
                    while (bl.hasNext()) {
                        Declaration declaration = (Declaration)bl.next();
                        if (!((Assignment)object2).assigns(declaration)) continue;
                        n7 = declaration.end;
                        break;
                    }
                }
                boolean bl2 = !((Assignment)object2).isDeclaration();
                ((Assignment)object2).declare(((Declaration)object.get((int)0)).begin);
                int declaration = ((Declaration)object.get((int)0)).register;
                Iterator n10 = object.iterator();
                while (n10.hasNext()) {
                    Declaration declaration2 = (Declaration)n10.next();
                    if (n7 != -1 && declaration2.end != n7 || declaration2.register < ((Block)object3).closeRegister) continue;
                    ((Assignment)object2).addLast(new VariableTarget(declaration2), registers.getValue(declaration2.register, n5 + 1), registers.getUpdated(declaration2.register, n5 - 1));
                    declaration = declaration2.register;
                }
                if (bl2) {
                    int n8 = this.getRegister(n5);
                    while (declaration < n8) {
                        ((Assignment)object2).addExcessValue(registers.getValue(++declaration, n5 + 1), registers.getUpdated(declaration, n5), declaration);
                    }
                }
            }
            n5 = n6;
        }
    }

    private boolean isMoveIntoTarget(Registers registers, int n) {
        if (this.code.isUpvalueDeclaration(n)) {
            return false;
        }
        switch (this.code.op(n)) {
            case MOVE: {
                return registers.isAssignable(this.code.A(n), n) && !registers.isLocal(this.code.B(n), n);
            }
            case SETGLOBAL: 
            case SETUPVAL: {
                return !registers.isLocal(this.code.A(n), n);
            }
            case SETTABLE: 
            case SETTABUP: {
                int n2 = this.code.C(n);
                if (this.f.isConstant(n2)) {
                    return false;
                }
                return !registers.isLocal(n2, n);
            }
            case SETTABLE54: 
            case SETI: 
            case SETFIELD: 
            case SETTABUP54: {
                if (this.code.k(n)) {
                    return false;
                }
                return !registers.isLocal(this.code.C(n), n);
            }
        }
        return false;
    }

    private Target getMoveIntoTargetTarget(Registers registers, int n, int n2) {
        switch (this.code.op(n)) {
            case MOVE: {
                return registers.getTarget(this.code.A(n), n);
            }
            case SETUPVAL: {
                return new UpvalueTarget(this.upvalues.getName(this.code.B(n)));
            }
            case SETGLOBAL: {
                return new GlobalTarget(this.f.getGlobalName(this.code.Bx(n)));
            }
            case SETTABLE: {
                return new TableTarget(registers.getExpression(this.code.A(n), n2), registers.getKExpression(this.code.B(n), n2));
            }
            case SETTABLE54: {
                return new TableTarget(registers.getExpression(this.code.A(n), n2), registers.getExpression(this.code.B(n), n2));
            }
            case SETI: {
                return new TableTarget(registers.getExpression(this.code.A(n), n2), ConstantExpression.createInteger(this.code.B(n)));
            }
            case SETFIELD: {
                return new TableTarget(registers.getExpression(this.code.A(n), n2), this.f.getConstantExpression(this.code.B(n)));
            }
            case SETTABUP: {
                int n3 = this.code.A(n);
                int n4 = this.code.B(n);
                return new TableTarget(this.upvalues.getExpression(n3), registers.getKExpression(n4, n2));
            }
            case SETTABUP54: {
                int n5 = this.code.A(n);
                int n6 = this.code.B(n);
                return new TableTarget(this.upvalues.getExpression(n5), this.f.getConstantExpression(n6));
            }
        }
        throw new IllegalStateException();
    }

    private Expression getMoveIntoTargetValue(Registers registers, int n, int n2) {
        int n3 = this.code.A(n);
        int n4 = this.code.B(n);
        int n5 = this.code.C(n);
        switch (this.code.op(n)) {
            case MOVE: {
                return registers.getValue(n4, n2);
            }
            case SETGLOBAL: 
            case SETUPVAL: {
                return registers.getExpression(n3, n2);
            }
            case SETTABLE: 
            case SETTABUP: {
                if (this.f.isConstant(n5)) {
                    throw new IllegalStateException();
                }
                return registers.getExpression(n5, n2);
            }
            case SETTABLE54: 
            case SETI: 
            case SETFIELD: 
            case SETTABUP54: {
                if (this.code.k(n)) {
                    throw new IllegalStateException();
                }
                return registers.getExpression(n5, n2);
            }
        }
        throw new IllegalStateException();
    }

    private int getMoveIntoTargetValueRegister(Registers registers, int n, int n2) {
        int n3 = this.code.A(n);
        int n4 = this.code.B(n);
        int n5 = this.code.C(n);
        switch (this.code.op(n)) {
            case MOVE: {
                return n4;
            }
            case SETGLOBAL: 
            case SETUPVAL: {
                return n3;
            }
            case SETTABLE: 
            case SETTABUP: {
                if (this.f.isConstant(n5)) {
                    throw new IllegalStateException();
                }
                return n5;
            }
            case SETTABLE54: 
            case SETI: 
            case SETFIELD: 
            case SETTABUP54: {
                if (this.code.k(n)) {
                    throw new IllegalStateException();
                }
                return n5;
            }
        }
        throw new IllegalStateException();
    }

    public int getRegister(int n) {
        while (this.code.isUpvalueDeclaration(n) || this.code.op(n) == Op.EXTRAARG || this.code.op(n) == Op.EXTRABYTE) {
            if (n == 1) {
                return -1;
            }
            --n;
        }
        return this.code.register(n);
    }

    public static class State {
        private Registers r;
        private byte[] flags;
        private Block outer;
    }

    public static enum Flag {
        SKIP,
        LABELS;

        public final int bit = 1 << this.ordinal();
    }
}

