/*
 * Decompiled with CFR 0.152.
 */
package unluac.decompile;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import unluac.Version;
import unluac.decompile.CloseType;
import unluac.decompile.Code;
import unluac.decompile.Declaration;
import unluac.decompile.Decompiler;
import unluac.decompile.Op;
import unluac.decompile.Registers;
import unluac.decompile.block.AlwaysLoop;
import unluac.decompile.block.Block;
import unluac.decompile.block.Break;
import unluac.decompile.block.ContainerBlock;
import unluac.decompile.block.DoEndBlock;
import unluac.decompile.block.ElseEndBlock;
import unluac.decompile.block.ForBlock;
import unluac.decompile.block.ForBlock50;
import unluac.decompile.block.ForBlock51;
import unluac.decompile.block.Goto;
import unluac.decompile.block.IfThenElseBlock;
import unluac.decompile.block.IfThenEndBlock;
import unluac.decompile.block.OnceLoop;
import unluac.decompile.block.OuterBlock;
import unluac.decompile.block.RepeatBlock;
import unluac.decompile.block.SetBlock;
import unluac.decompile.block.TForBlock;
import unluac.decompile.block.WhileBlock50;
import unluac.decompile.block.WhileBlock51;
import unluac.decompile.condition.AndCondition;
import unluac.decompile.condition.BinaryCondition;
import unluac.decompile.condition.Condition;
import unluac.decompile.condition.ConstantCondition;
import unluac.decompile.condition.FinalSetCondition;
import unluac.decompile.condition.FixedCondition;
import unluac.decompile.condition.OrCondition;
import unluac.decompile.condition.TestCondition;
import unluac.parse.LFunction;
import unluac.util.Stack;

public class ControlFlowHandler {
    public static boolean verbose = false;

    public static Result process(Decompiler decompiler, Registers registers) {
        State state = new State();
        state.d = decompiler;
        state.function = decompiler.function;
        state.r = registers;
        state.code = decompiler.code;
        state.labels = new boolean[decompiler.code.length + 1];
        ControlFlowHandler.find_reverse_targets(state);
        ControlFlowHandler.find_branches(state);
        ControlFlowHandler.combine_branches(state);
        ControlFlowHandler.resolve_lines(state);
        ControlFlowHandler.initialize_blocks(state);
        ControlFlowHandler.find_fixed_blocks(state);
        ControlFlowHandler.find_while_loops(state, decompiler.declList);
        ControlFlowHandler.find_repeat_loops(state);
        ControlFlowHandler.find_if_break(state, decompiler.declList);
        ControlFlowHandler.find_set_blocks(state);
        ControlFlowHandler.find_pseudo_goto_statements(state, decompiler.declList);
        ControlFlowHandler.find_do_blocks(state, decompiler.declList);
        Collections.sort(state.blocks);
        return new Result(state);
    }

    private static void find_reverse_targets(State state) {
        Code code = state.code;
        state.reverse_targets = new boolean[state.code.length + 1];
        boolean[] blArray = state.reverse_targets;
        for (int i = 1; i <= code.length; ++i) {
            int n;
            if (!ControlFlowHandler.is_jmp(state, i) || (n = code.target(i)) > i) continue;
            blArray[n] = true;
        }
    }

    private static void resolve_lines(State state) {
        int[] nArray = new int[state.code.length + 1];
        Arrays.fill(nArray, -1);
        for (int i = 1; i <= state.code.length; ++i) {
            int n = i;
            Branch branch = state.branches[i];
            while (branch != null && branch.type == Branch.Type.jump) {
                if (nArray[n] >= 1) {
                    n = nArray[n];
                    break;
                }
                if (nArray[n] == -2) {
                    n = branch.targetSecond;
                    break;
                }
                nArray[n] = -2;
                n = branch.targetSecond;
                branch = state.branches[n];
            }
            if (n == i && state.code.op(i) == Op.JMP52 && ControlFlowHandler.is_close(state, i)) {
                n = i + 1;
            }
            nArray[i] = n;
        }
        state.resolved = nArray;
    }

    private static int find_loadboolblock(State state, int n) {
        if (n < 1) {
            return -1;
        }
        int n2 = -1;
        Op op = state.code.op(n);
        if (op == Op.LOADBOOL) {
            if (state.code.C(n) != 0) {
                n2 = n;
            } else if (n - 1 >= 1 && state.code.op(n - 1) == Op.LOADBOOL && state.code.C(n - 1) != 0) {
                n2 = n - 1;
            }
        } else if (op == Op.LFALSESKIP) {
            n2 = n;
        } else if (n - 1 >= 1 && op == Op.LOADTRUE && state.code.op(n - 1) == Op.LFALSESKIP) {
            n2 = n - 1;
        }
        return n2;
    }

    private static void handle_loadboolblock(State state, boolean[] blArray, int n, Condition condition, int n2, int n3) {
        int n4;
        int n5;
        boolean bl;
        Op op = state.code.op(n3);
        if (op == Op.LOADBOOL) {
            bl = state.code.B(n3) != 0;
        } else if (op == Op.LFALSESKIP) {
            bl = false;
        } else if (op == Op.LOADTRUE) {
            bl = true;
        } else {
            throw new IllegalStateException();
        }
        int n6 = -1;
        if (n - 1 >= 1 && ControlFlowHandler.is_jmp(state, n - 1)) {
            n5 = state.code.target(n - 1);
            n4 = -1;
            if (ControlFlowHandler.is_jmp_raw(state, n + 2)) {
                n4 = state.code.target(n + 2);
            }
            if (n5 == n + 2 || n5 == n4) {
                blArray[n - 1] = true;
                n6 = n - 2;
            }
        }
        n5 = 0;
        if (bl) {
            n5 = 1;
            condition = condition.inverse();
        }
        n4 = ControlFlowHandler.is_jmp(state, n2);
        int n7 = n2 + 2;
        Branch branch = n4 != 0 ? new Branch(n2, n2, Branch.Type.testset, condition, --n7, n + 2, null) : (n2 + 2 == n ? new Branch(n, n, Branch.Type.finalset, condition, n7, n + 2, null) : new Branch(n2, n2, Branch.Type.testset, condition, n7, n + 2, null));
        branch.target = state.code.A(n);
        branch.inverseValue = n5;
        ControlFlowHandler.insert_branch(state, branch);
        if (n6 != -1) {
            if (n4 != 0 && n6 < n7) {
                ++n6;
            }
            FinalSetCondition finalSetCondition = new FinalSetCondition(n6, branch.target);
            Branch branch2 = new Branch(n6, n6, Branch.Type.finalset, finalSetCondition, n6, n + 2, finalSetCondition);
            branch2.target = branch.target;
            ControlFlowHandler.insert_branch(state, branch2);
            branch.finalset = finalSetCondition;
        }
    }

    private static void handle_test(State state, boolean[] blArray, int n, Condition condition, int n2, boolean bl) {
        Code code = state.code;
        int n3 = ControlFlowHandler.find_loadboolblock(state, n2);
        if (n3 >= 1) {
            if (bl) {
                condition = condition.inverse();
            }
            ControlFlowHandler.handle_loadboolblock(state, blArray, n3, condition, n, n2);
        } else {
            int n4;
            int n5 = n4 = n2 - 2 >= 1 ? ControlFlowHandler.find_loadboolblock(state, n2 - 2) : -1;
            if (n4 != -1 && n4 == n2 - 2 && code.A(n2 - 2) == condition.register() && !ControlFlowHandler.has_statement(state, n + 2, n2 - 3)) {
                ControlFlowHandler.handle_testset(state, blArray, n, condition, n2, condition.register(), bl);
            } else {
                if (bl) {
                    condition = condition.inverse();
                }
                Branch branch = new Branch(n, n, Branch.Type.test, condition, n + 2, n2, null);
                branch.target = code.A(n);
                if (bl) {
                    branch.inverseValue = true;
                }
                ControlFlowHandler.insert_branch(state, branch);
            }
        }
        blArray[n + 1] = true;
    }

    private static void handle_testset(State state, boolean[] blArray, int n, Condition condition, int n2, int n3, boolean bl) {
        int n4;
        if (state.r.isNoDebug && ControlFlowHandler.find_loadboolblock(state, n2) == -1) {
            if (bl) {
                condition = condition.inverse();
            }
            Branch branch = new Branch(n, n, Branch.Type.test, condition, n + 2, n2, null);
            branch.target = state.code.A(n);
            if (bl) {
                branch.inverseValue = true;
            }
            ControlFlowHandler.insert_branch(state, branch);
            blArray[n + 1] = true;
            return;
        }
        Branch branch = new Branch(n, n, Branch.Type.testset, condition, n + 2, n2, null);
        branch.target = n3;
        if (bl) {
            branch.inverseValue = true;
        }
        blArray[n + 1] = true;
        ControlFlowHandler.insert_branch(state, branch);
        int n5 = n2 - 1;
        int n6 = ControlFlowHandler.find_loadboolblock(state, n2 - 2);
        if (n6 != -1 && state.code.A(n6) == n3) {
            n5 = n6;
            if (n6 - 2 >= 1 && ControlFlowHandler.is_jmp(state, n6 - 1) && (state.code.target(n6 - 1) == n2 || ControlFlowHandler.is_jmp_raw(state, n2) && state.code.target(n6 - 1) == state.code.target(n2))) {
                n5 = n6 - 2;
            }
            n4 = n5;
        } else {
            n4 = Math.max(n5, n + 2);
        }
        FinalSetCondition finalSetCondition = new FinalSetCondition(n5, n3);
        Branch branch2 = new Branch(n4, n4, Branch.Type.finalset, finalSetCondition, n5, n2, finalSetCondition);
        branch2.target = n3;
        ControlFlowHandler.insert_branch(state, branch2);
        branch.finalset = finalSetCondition;
    }

    private static void process_condition(State state, boolean[] blArray, int n, Condition condition, boolean bl) {
        int n2;
        int n3 = state.code.target(n + 1);
        if (bl) {
            condition = condition.inverse();
        }
        if ((n2 = ControlFlowHandler.find_loadboolblock(state, n3)) >= 1) {
            ControlFlowHandler.handle_loadboolblock(state, blArray, n2, condition, n, n3);
        } else {
            Branch branch = new Branch(n, n, Branch.Type.comparison, condition, n + 2, n3, null);
            if (bl) {
                branch.inverseValue = true;
            }
            ControlFlowHandler.insert_branch(state, branch);
        }
        blArray[n + 1] = true;
    }

    private static void find_branches(State state) {
        Code code = state.code;
        state.branches = new Branch[state.code.length + 1];
        state.setbranches = new Branch[state.code.length + 1];
        state.finalsetbranches = new ArrayList(state.code.length + 1);
        for (int i = 0; i <= state.code.length; ++i) {
            state.finalsetbranches.add(null);
        }
        boolean[] blArray = new boolean[code.length + 1];
        block13: for (int i = 1; i <= code.length; ++i) {
            if (blArray[i]) continue;
            switch (code.op(i)) {
                case EQ: 
                case LT: 
                case LE: {
                    BinaryCondition.Operator operator = BinaryCondition.Operator.EQ;
                    if (code.op(i) == Op.LT) {
                        operator = BinaryCondition.Operator.LT;
                    }
                    if (code.op(i) == Op.LE) {
                        operator = BinaryCondition.Operator.LE;
                    }
                    Condition.Operand operand = new Condition.Operand(Condition.OperandType.RK, code.B(i));
                    Object object3 = new Condition.Operand(Condition.OperandType.RK, code.C(i));
                    Object object2 = new BinaryCondition(operator, i, operand, (Condition.Operand)object3);
                    ControlFlowHandler.process_condition(state, blArray, i, (Condition)object2, code.A(i) != 0);
                    continue block13;
                }
                case EQ54: 
                case LT54: 
                case LE54: {
                    BinaryCondition.Operator operator = BinaryCondition.Operator.EQ;
                    if (code.op(i) == Op.LT54) {
                        operator = BinaryCondition.Operator.LT;
                    }
                    if (code.op(i) == Op.LE54) {
                        operator = BinaryCondition.Operator.LE;
                    }
                    Condition.Operand operand = new Condition.Operand(Condition.OperandType.R, code.A(i));
                    Object object3 = new Condition.Operand(Condition.OperandType.R, code.B(i));
                    Object object2 = new BinaryCondition(operator, i, operand, (Condition.Operand)object3);
                    ControlFlowHandler.process_condition(state, blArray, i, (Condition)object2, code.k(i));
                    continue block13;
                }
                case EQK: {
                    BinaryCondition.Operator operator = BinaryCondition.Operator.EQ;
                    Condition.Operand operand = new Condition.Operand(Condition.OperandType.R, code.A(i));
                    Object object3 = new Condition.Operand(Condition.OperandType.K, code.B(i));
                    Object object2 = new BinaryCondition(operator, i, (Condition.Operand)object3, operand);
                    ControlFlowHandler.process_condition(state, blArray, i, (Condition)object2, code.k(i));
                    continue block13;
                }
                case EQI: 
                case LTI: 
                case LEI: 
                case GTI: 
                case GEI: {
                    Object object;
                    BinaryCondition.Operator operator = BinaryCondition.Operator.EQ;
                    if (code.op(i) == Op.LTI) {
                        operator = BinaryCondition.Operator.LT;
                    }
                    if (code.op(i) == Op.LEI) {
                        operator = BinaryCondition.Operator.LE;
                    }
                    if (code.op(i) == Op.GTI) {
                        operator = BinaryCondition.Operator.GT;
                    }
                    if (code.op(i) == Op.GEI) {
                        operator = BinaryCondition.Operator.GE;
                    }
                    Condition.OperandType operandType = code.C(i) != 0 ? Condition.OperandType.F : Condition.OperandType.I;
                    Object object3 = new Condition.Operand(Condition.OperandType.R, code.A(i));
                    Object object2 = new Condition.Operand(operandType, code.sB(i));
                    if (operator == BinaryCondition.Operator.EQ) {
                        object = object3;
                        object3 = object2;
                        object2 = object;
                    }
                    object = new BinaryCondition(operator, i, (Condition.Operand)object3, (Condition.Operand)object2);
                    ControlFlowHandler.process_condition(state, blArray, i, (Condition)object, code.k(i));
                    continue block13;
                }
                case TEST50: {
                    TestCondition testCondition = new TestCondition(i, code.B(i));
                    int n = code.target(i + 1);
                    if (code.A(i) == code.B(i)) {
                        ControlFlowHandler.handle_test(state, blArray, i, testCondition, n, code.C(i) != 0);
                        continue block13;
                    }
                    ControlFlowHandler.handle_testset(state, blArray, i, testCondition, n, code.A(i), code.C(i) != 0);
                    continue block13;
                }
                case TEST: {
                    int n = code.target(i + 1);
                    TestCondition testCondition = new TestCondition(i, code.A(i));
                    ControlFlowHandler.handle_test(state, blArray, i, testCondition, n, code.C(i) != 0);
                    continue block13;
                }
                case TEST54: {
                    int n = code.target(i + 1);
                    TestCondition testCondition = new TestCondition(i, code.A(i));
                    ControlFlowHandler.handle_test(state, blArray, i, testCondition, n, code.k(i));
                    continue block13;
                }
                case TESTSET: {
                    TestCondition testCondition = new TestCondition(i, code.B(i));
                    int n = code.target(i + 1);
                    ControlFlowHandler.handle_testset(state, blArray, i, testCondition, n, code.A(i), code.C(i) != 0);
                    continue block13;
                }
                case TESTSET54: {
                    TestCondition testCondition = new TestCondition(i, code.B(i));
                    int n = code.target(i + 1);
                    ControlFlowHandler.handle_testset(state, blArray, i, testCondition, n, code.A(i), code.k(i));
                    continue block13;
                }
                case JMP: 
                case JMP52: 
                case JMP54: {
                    if (!ControlFlowHandler.is_jmp(state, i)) continue block13;
                    int n = code.target(i);
                    int n2 = ControlFlowHandler.find_loadboolblock(state, n);
                    if (n2 >= 1) {
                        ControlFlowHandler.handle_loadboolblock(state, blArray, n2, new ConstantCondition(-1, false), i, n);
                        continue block13;
                    }
                    Object object3 = new Branch(i, i, Branch.Type.jump, null, n, n, null);
                    ControlFlowHandler.insert_branch(state, (Branch)object3);
                    continue block13;
                }
            }
        }
        ControlFlowHandler.link_branches(state);
    }

    private static void combine_branches(State state) {
        Branch branch = state.end_branch;
        while (branch != null) {
            branch = ControlFlowHandler.combine_left((State)state, (Branch)branch).previous;
        }
    }

    private static void initialize_blocks(State state) {
        state.blocks = new LinkedList<Block>();
    }

    private static void find_fixed_blocks(State state) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        List<Block> list = state.blocks;
        Registers registers = state.r;
        Code code = state.code;
        Op op = state.function.header.version.tfortarget.get();
        Op op2 = state.function.header.version.fortarget.get();
        list.add(new OuterBlock(state.function, state.code.length));
        boolean[] blArray = new boolean[state.code.length + 1];
        Branch branch = state.begin_branch;
        while (branch != null) {
            if (branch.type == Branch.Type.jump) {
                n6 = branch.line;
                n5 = branch.targetFirst;
                if (code.op(n5) == op && !blArray[n5]) {
                    blArray[n5] = true;
                    n4 = code.A(n5);
                    n3 = code.C(n5);
                    if (n3 == 0) {
                        throw new IllegalStateException();
                    }
                    ControlFlowHandler.remove_branch(state, state.branches[n6]);
                    if (state.branches[n5 + 1] != null) {
                        ControlFlowHandler.remove_branch(state, state.branches[n5 + 1]);
                    }
                    n2 = 0;
                    n = 0;
                    int n7 = n5 - 1;
                    if (n7 >= n6 + 1 && ControlFlowHandler.is_close(state, n7) && ControlFlowHandler.get_close_value(state, n7) == n4 + 3) {
                        n2 = 1;
                        --n7;
                    }
                    if (n7 >= n6 + 1 && ControlFlowHandler.is_close(state, n7) && ControlFlowHandler.get_close_value(state, n7) <= n4 + 3 + n3) {
                        n = 1;
                    }
                    TForBlock tForBlock = TForBlock.make51(state.function, n6 + 1, n5 + 2, n4, n3, n2 != 0, n != 0);
                    tForBlock.handleVariableDeclarations(registers);
                    list.add(tForBlock);
                } else if (code.op(n5) == op2 && !blArray[n5]) {
                    blArray[n5] = true;
                    n4 = code.A(n5);
                    ForBlock50 forBlock50 = new ForBlock50(state.function, n6 + 1, n5 + 1, n4, ControlFlowHandler.get_close_type(state, n5 - 1), n5 - 1);
                    ((ForBlock)forBlock50).handleVariableDeclarations(registers);
                    list.add(forBlock50);
                    ControlFlowHandler.remove_branch(state, branch);
                }
            }
            branch = branch.next;
        }
        block6: for (n6 = 1; n6 <= code.length; ++n6) {
            switch (code.op(n6)) {
                case FORPREP: 
                case FORPREP54: {
                    n5 = code.A(n6);
                    n4 = code.target(n6);
                    n3 = n6 + 1;
                    n2 = n4 + 1;
                    n = 0;
                    boolean bl = false;
                    int n8 = n4 - 1;
                    if (n8 >= n6 + 1 && ControlFlowHandler.is_close(state, n8) && ControlFlowHandler.get_close_value(state, n8) == n5 + 3) {
                        n = 1;
                        --n8;
                    } else if (n2 <= code.length && ControlFlowHandler.is_close(state, n2) && ControlFlowHandler.get_close_value(state, n2) == n5 + 3) {
                        bl = true;
                    }
                    ForBlock51 forBlock51 = new ForBlock51(state.function, n3, n2, n5, ControlFlowHandler.get_close_type(state, n8), n8, n != 0, bl);
                    ((ForBlock)forBlock51).handleVariableDeclarations(registers);
                    list.add(forBlock51);
                    continue block6;
                }
                case TFORPREP: {
                    n5 = code.target(n6);
                    n4 = code.A(n5);
                    n3 = code.C(n5);
                    n2 = 0;
                    n = n5 - 1;
                    if (n >= n6 + 1 && ControlFlowHandler.is_close(state, n) && ControlFlowHandler.get_close_value(state, n) == n4 + 3 + n3) {
                        n2 = 1;
                    }
                    TForBlock tForBlock = TForBlock.make50(state.function, n6 + 1, n5 + 2, n4, n3 + 1, n2 != 0);
                    tForBlock.handleVariableDeclarations(registers);
                    list.add(tForBlock);
                    ControlFlowHandler.remove_branch(state, state.branches[n5 + 1]);
                    continue block6;
                }
                case TFORPREP54: {
                    n5 = code.target(n6);
                    n4 = code.A(n6);
                    n3 = code.C(n5);
                    n2 = 0;
                    n = n5 - 1;
                    if (n >= n6 + 1 && ControlFlowHandler.is_close(state, n) && ControlFlowHandler.get_close_value(state, n) == n4 + 4) {
                        n2 = 1;
                        n -= 1;
                    }
                    TForBlock tForBlock = TForBlock.make54(state.function, n6 + 1, n5 + 2, n4, n3, n2 != 0);
                    tForBlock.handleVariableDeclarations(registers);
                    list.add(tForBlock);
                    continue block6;
                }
            }
        }
    }

    private static void unredirect(State state, int n, int n2, int n3, int n4) {
        Branch branch = state.begin_branch;
        while (branch != null) {
            if (branch.line >= n && branch.line < n2 && branch.targetSecond == n4) {
                if (branch.type == Branch.Type.finalset) {
                    branch.targetFirst = n3 - 1;
                    branch.targetSecond = n3;
                    if (branch.finalset != null) {
                        branch.finalset.line = n3 - 1;
                    }
                } else {
                    branch.targetSecond = n3;
                    if (branch.targetFirst == n4) {
                        branch.targetFirst = n3;
                    }
                }
            }
            branch = branch.next;
        }
    }

    private static void find_while_loops(State state, Declaration[] declarationArray) {
        List<Block> list = state.blocks;
        Branch branch = state.end_branch;
        while (branch != null) {
            if (branch.type == Branch.Type.jump && branch.targetFirst <= branch.line && !ControlFlowHandler.splits_decl(branch.targetFirst, branch.targetFirst, branch.line + 1, declarationArray)) {
                int n;
                int n2 = n = branch.targetFirst;
                int n3 = branch.line + 1;
                Branch branch2 = state.begin_branch;
                int n4 = -1;
                while (!(branch2 == null || ControlFlowHandler.is_conditional(branch2) && branch2.line >= n2 && branch2.line < branch.line && state.resolved[branch2.targetSecond] == state.resolved[n3] && n4 <= branch2.line)) {
                    if (branch2.line >= n2) {
                        n4 = Math.max(n4, branch2.targetSecond);
                    }
                    branch2 = branch2.next;
                }
                if (branch2 != null) {
                    boolean bl = state.reverse_targets[n2];
                    state.reverse_targets[n2] = false;
                    if (ControlFlowHandler.has_statement(state, n2, branch2.line - 1)) {
                        branch2 = null;
                    }
                    state.reverse_targets[n2] = bl;
                }
                if (state.function.header.version.whileformat.get() == Version.WhileFormat.BOTTOM_CONDITION) {
                    branch2 = null;
                }
                ContainerBlock containerBlock = null;
                if (branch2 != null) {
                    branch2.targetSecond = n3;
                    ControlFlowHandler.remove_branch(state, branch2);
                    containerBlock = new WhileBlock51(state.function, branch2.cond, branch2.targetFirst, branch2.targetSecond, n2, ControlFlowHandler.get_close_type(state, n3 - 2), n3 - 2);
                    ControlFlowHandler.unredirect(state, n2, n3, branch.line, n2);
                }
                if (containerBlock == null && branch.line - 5 >= 1 && state.code.op(branch.line - 3) == Op.CLOSE && ControlFlowHandler.is_jmp_raw(state, branch.line - 2) && state.code.target(branch.line - 2) == n3 && state.code.op(branch.line - 1) == Op.CLOSE) {
                    branch2 = branch.previous;
                    while (!(branch2 == null || ControlFlowHandler.is_conditional(branch2) && branch2.line2 == branch.line - 5)) {
                        branch2 = branch2.previous;
                    }
                    if (branch2 != null) {
                        Branch branch3 = state.branches[branch.line - 2];
                        if (branch3 == null) {
                            throw new IllegalStateException();
                        }
                        int n5 = branch.line - 3;
                        if (state.function.header.version.closeinscope.get().booleanValue()) {
                            n5 = branch.line - 2;
                        }
                        containerBlock = new RepeatBlock(state.function, branch2.cond, branch.targetFirst, branch.line + 1, CloseType.NONE, -1, true, n5);
                        ControlFlowHandler.remove_branch(state, branch2);
                        ControlFlowHandler.remove_branch(state, branch3);
                    }
                }
                if (containerBlock == null) {
                    boolean bl = false;
                    if (state.function.header.version.whileformat.get() == Version.WhileFormat.BOTTOM_CONDITION) {
                        bl = true;
                        if (n2 - 1 >= 1 && state.branches[n2 - 1] != null) {
                            Branch branch4 = state.branches[n2 - 1];
                            if (branch4.type == Branch.Type.jump && branch4.targetFirst == branch.line) {
                                ControlFlowHandler.remove_branch(state, branch4);
                                bl = false;
                            }
                        }
                    }
                    containerBlock = new AlwaysLoop(state.function, n2, n3, ControlFlowHandler.get_close_type(state, n3 - 2), n3 - 2, bl);
                    ControlFlowHandler.unredirect(state, n2, n3, branch.line, n2);
                }
                ControlFlowHandler.remove_branch(state, branch);
                list.add(containerBlock);
            }
            branch = branch.previous;
        }
    }

    private static void find_repeat_loops(State state) {
        List<Block> list = state.blocks;
        Branch branch = state.begin_branch;
        while (branch != null) {
            if (ControlFlowHandler.is_conditional(branch) && branch.targetSecond < branch.targetFirst) {
                int n;
                ContainerBlock containerBlock = null;
                if (state.function.header.version.whileformat.get() == Version.WhileFormat.BOTTOM_CONDITION && (n = branch.targetSecond - 1) >= 1 && state.branches[n] != null && state.branches[n].type == Branch.Type.jump) {
                    Branch branch2 = state.branches[n];
                    if (branch2.targetSecond <= branch.line) {
                        if (ControlFlowHandler.has_statement(state, branch2.targetSecond, branch.line - 1)) {
                            branch2 = null;
                        }
                        if (branch2 != null) {
                            containerBlock = new WhileBlock50(state.function, branch.cond.inverse(), n + 1, branch.targetFirst, branch2.targetFirst, ControlFlowHandler.get_close_type(state, branch2.targetFirst - 1), branch2.targetFirst - 1);
                            ControlFlowHandler.remove_branch(state, branch2);
                            ControlFlowHandler.unredirect(state, 1, branch2.line, branch2.line, branch2.targetSecond);
                        }
                    }
                }
                if (containerBlock == null) {
                    if (state.function.header.version.extendedrepeatscope.get().booleanValue()) {
                        for (n = branch.line - 1; n >= 1 && !ControlFlowHandler.is_statement(state, n); --n) {
                        }
                        containerBlock = new RepeatBlock(state.function, branch.cond, branch.targetSecond, branch.targetFirst, ControlFlowHandler.get_close_type(state, n), n, true, n);
                    } else {
                        containerBlock = state.function.header.version.closesemantics.get() == Version.CloseSemantics.JUMP ? new RepeatBlock(state.function, branch.cond, branch.targetSecond, branch.targetFirst, ControlFlowHandler.get_close_type(state, branch.targetFirst), branch.targetFirst, false, -1) : new RepeatBlock(state.function, branch.cond, branch.targetSecond, branch.targetFirst, CloseType.NONE, -1, false, -1);
                    }
                }
                ControlFlowHandler.remove_branch(state, branch);
                list.add(containerBlock);
            }
            branch = branch.next;
        }
    }

    private static boolean splits_decl(int n, int n2, int n3, Declaration[] declarationArray) {
        for (Declaration declaration : declarationArray) {
            if (!declaration.isSplitBy(n, n2, n3)) continue;
            return true;
        }
        return false;
    }

    private static int stack_reach(State state, Stack<Branch> stack) {
        for (int i = 0; i < stack.size(); ++i) {
            Branch branch = stack.peek(i);
            Block block = ControlFlowHandler.enclosing_breakable_block(state, branch.line);
            if (block != null && block.end == branch.targetSecond) continue;
            return branch.targetSecond;
        }
        return Integer.MAX_VALUE;
    }

    private static Block resolve_if_stack(State state, Stack<Branch> stack, int n) {
        IfThenEndBlock ifThenEndBlock = null;
        if (!stack.isEmpty() && ControlFlowHandler.stack_reach(state, stack) <= n) {
            Branch branch = stack.pop();
            int n2 = state.code.target(branch.targetFirst - 1);
            if (state.function.header.version.useifbreakrewrite.get().booleanValue() && state.function.header.version.usegoto.get().booleanValue() && branch.targetFirst + 1 == branch.targetSecond && ControlFlowHandler.is_jmp(state, branch.targetFirst)) {
                ifThenEndBlock = new IfThenEndBlock(state.function, state.r, branch.cond.inverse(), branch.targetFirst - 1, branch.targetFirst - 1);
                ((Block)ifThenEndBlock).addStatement(new Goto(state.function, branch.targetFirst - 1, branch.targetSecond));
                state.labels[branch.targetSecond] = true;
            } else {
                ifThenEndBlock = new IfThenEndBlock(state.function, state.r, branch.cond, branch.targetFirst, branch.targetSecond, ControlFlowHandler.get_close_type(state, branch.targetSecond - 1), branch.targetSecond - 1, n2 != branch.targetSecond);
            }
            state.blocks.add(ifThenEndBlock);
            ControlFlowHandler.remove_branch(state, branch);
        }
        return ifThenEndBlock;
    }

    private static void resolve_else(State state, Stack<Branch> stack, Stack<Branch> stack2, Stack<ElseEndBlock> stack3, Branch branch, Branch branch2, int n) {
        Block block;
        Object object;
        while (!stack3.isEmpty() && stack3.peek().end == n && stack3.peek().begin >= branch.targetFirst) {
            stack3.pop().end = branch2.line;
        }
        Stack<Object> stack4 = new Stack<Object>();
        while (!stack2.isEmpty() && stack2.peek().targetSecond == n && stack2.peek().line > branch.line) {
            object = stack2.pop();
            ((Branch)object).targetSecond = branch2.line;
            block = ControlFlowHandler.enclosing_breakable_block(state, ((Branch)object).line);
            if (block != null && ((Branch)object).targetSecond >= block.end) {
                stack4.push(object);
                continue;
            }
            stack.push((Branch)object);
            Block block2 = ControlFlowHandler.resolve_if_stack(state, stack, branch2.line);
            if (block2 != null) continue;
            throw new IllegalStateException();
        }
        while (!stack4.isEmpty()) {
            stack2.push((Branch)stack4.pop());
        }
        ControlFlowHandler.unredirect_finalsets(state, n, branch2.line, branch.targetFirst);
        object = new Stack();
        while (!stack.isEmpty() && stack.peek().line > branch.line && stack.peek().targetSecond == branch2.targetSecond) {
            stack.peek().targetSecond = branch2.line;
            ((Stack)object).push(stack.pop());
        }
        while (!((Stack)object).isEmpty()) {
            stack.push((Branch)((Stack)object).pop());
        }
        branch2.targetSecond = n;
        state.blocks.add(new IfThenElseBlock(state.function, branch.cond, branch.targetFirst, branch.targetSecond, branch2.targetSecond, ControlFlowHandler.get_close_type(state, branch.targetSecond - 2), branch.targetSecond - 2));
        block = new ElseEndBlock(state.function, branch.targetSecond, branch2.targetSecond, ControlFlowHandler.get_close_type(state, branch2.targetSecond - 1), branch2.targetSecond - 1);
        state.blocks.add(block);
        stack3.push((ElseEndBlock)block);
        ControlFlowHandler.remove_branch(state, branch2);
    }

    private static boolean is_hanger_resolvable(State state, Declaration[] declarationArray, Branch branch, Branch branch2) {
        return branch.targetSecond == branch2.targetFirst && ControlFlowHandler.enclosing_block(state, branch.line) == ControlFlowHandler.enclosing_block(state, branch2.line) && !ControlFlowHandler.splits_decl(branch.line, branch.targetFirst, branch2.line, declarationArray) && (state.function.header.version.useifbreakrewrite.get() == false || branch.targetFirst != branch2.line - 1 || !ControlFlowHandler.is_jmp(state, branch2.line - 1));
    }

    private static boolean is_hanger_resolvable(State state, Declaration[] declarationArray, Branch branch, Stack<Branch> stack) {
        for (int i = 0; i < stack.size(); ++i) {
            if (!ControlFlowHandler.is_hanger_resolvable(state, declarationArray, branch, stack.peek(i))) continue;
            return true;
        }
        return false;
    }

    private static void resolve_hanger(State state, Declaration[] declarationArray, Stack<Branch> stack, Branch branch, Branch branch2) {
        branch.targetSecond = branch2.line;
        stack.push(branch);
        Block block = ControlFlowHandler.resolve_if_stack(state, stack, branch2.line);
        if (block == null) {
            throw new IllegalStateException();
        }
    }

    private static void resolve_hangers(State state, Declaration[] declarationArray, Stack<Branch> stack, Stack<Branch> stack2, Branch branch) {
        while (!stack2.isEmpty() && ControlFlowHandler.is_hanger_resolvable(state, declarationArray, stack2.peek(), branch)) {
            ControlFlowHandler.resolve_hanger(state, declarationArray, stack, stack2.pop(), branch);
        }
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    private static void find_if_break(State var0, Declaration[] var1_1) {
        var2_2 = new Stack<Branch>();
        var3_3 = new Stack<Branch>();
        var4_4 = new Stack<ElseEndBlock>();
        var5_5 = var0.begin_branch;
        var6_6 = new Stack<Branch>();
        while (var5_5 != null) {
            while (ControlFlowHandler.resolve_if_stack(var0, var2_2, var5_5.line2) != null) {
            }
            while (!var4_4.isEmpty() && ((ElseEndBlock)var4_4.peek()).end <= var5_5.line) {
                var4_4.pop();
            }
            while (!var6_6.isEmpty() && !ControlFlowHandler.enclosing_block(var0, ((Branch)var6_6.peek()).line).contains(var5_5.line)) {
                ControlFlowHandler.resolve_hangers(var0, var1_1, var2_2, var3_3, (Branch)var6_6.pop());
            }
            if (ControlFlowHandler.is_conditional(var5_5)) {
                var7_7 = ControlFlowHandler.enclosing_unprotected_block(var0, var5_5.line);
                if (var5_5.targetFirst > var5_5.targetSecond) {
                    throw new IllegalStateException();
                }
                if (var7_7 != null && !var7_7.contains(var5_5.targetSecond) && var5_5.targetSecond == var7_7.getUnprotectedTarget()) {
                    var5_5.targetSecond = var7_7.getUnprotectedLine();
                }
                var8_9 = ControlFlowHandler.enclosing_breakable_block(var0, var5_5.line);
                if (!var2_2.isEmpty() && var2_2.peek().targetSecond < var5_5.targetSecond || var8_9 != null && !var8_9.contains(var5_5.targetSecond)) {
                    var3_3.push(var5_5);
                } else {
                    var2_2.push(var5_5);
                }
            } else if (var5_5.type == Branch.Type.jump) {
                var7_8 = var5_5.line;
                var8_9 = ControlFlowHandler.enclosing_block(var0, var5_5.line);
                var9_10 = var5_5.targetSecond;
                var10_13 = ControlFlowHandler.enclosing_unprotected_block(var0, var5_5.line);
                if (var10_13 != null && !var10_13.contains(var5_5.targetSecond) && var9_10 == var0.resolved[var10_13.getUnprotectedTarget()]) {
                    var9_10 = var10_13.getUnprotectedLine();
                }
                var11_14 = false;
                var12_15 = ControlFlowHandler.enclosing_breakable_block(var0, var7_8);
                if (var12_15 != null && (var5_5.targetFirst == var12_15.end || var5_5.targetFirst == var0.resolved[var12_15.end])) {
                    var13_16 /* !! */  = new Break(var0.function, var5_5.line, var5_5.targetFirst);
                    if (!var3_3.isEmpty() && var3_3.peek().targetSecond == var5_5.targetFirst && ControlFlowHandler.enclosing_block(var0, var3_3.peek().line) == var8_9 && (var2_2.isEmpty() || var2_2.peek().line < var3_3.peek().line || var3_3.peek().line > var2_2.peek().line)) {
                        var6_6.push(var5_5);
                    }
                    ControlFlowHandler.unredirect_finalsets(var0, var5_5.targetFirst, var7_8, var12_15.begin);
                    var0.blocks.add(var13_16 /* !! */ );
                    ControlFlowHandler.remove_branch(var0, var5_5);
                    var11_14 = true;
                }
                if (!var11_14 && var0.function.header.version.usegoto.get().booleanValue() && var12_15 != null && !var12_15.contains(var5_5.targetFirst) && var0.resolved[var5_5.targetFirst] != var0.resolved[var12_15.end]) {
                    var13_16 /* !! */  = new Goto(var0.function, var5_5.line, var5_5.targetFirst);
                    if (!var3_3.isEmpty() && var3_3.peek().targetSecond == var5_5.targetFirst && ControlFlowHandler.enclosing_block(var0, var3_3.peek().line) == var8_9 && (var2_2.isEmpty() || var3_3.peek().line > var2_2.peek().line)) {
                        var6_6.push(var5_5);
                    }
                    ControlFlowHandler.unredirect_finalsets(var0, var5_5.targetFirst, var7_8, 1);
                    var0.blocks.add(var13_16 /* !! */ );
                    var0.labels[var5_5.targetFirst] = true;
                    ControlFlowHandler.remove_branch(var0, var5_5);
                    var11_14 = true;
                }
                if (!var11_14 && !var2_2.isEmpty() && var2_2.peek().targetSecond - 1 == var5_5.line && var8_9.contains(var5_5.line, var5_5.targetSecond) && var5_5.targetSecond > var5_5.line) {
                    var13_16 /* !! */  = var2_2.peek();
                    while (var13_16 /* !! */  != null && var13_16 /* !! */ .targetSecond - 1 == var5_5.line && ControlFlowHandler.splits_decl(var13_16 /* !! */ .line, var13_16 /* !! */ .targetFirst, var13_16 /* !! */ .targetSecond, var1_1)) {
                        var14_22 /* !! */  = ControlFlowHandler.resolve_if_stack(var0, var2_2, var13_16 /* !! */ .targetSecond);
                        if (var14_22 /* !! */  == null) {
                            throw new IllegalStateException();
                        }
                        var13_16 /* !! */  = var2_2.isEmpty() != false ? null : var2_2.peek();
                    }
                    if (var13_16 /* !! */  != null && var13_16 /* !! */ .targetSecond - 1 == var5_5.line) {
                        if (var13_16 /* !! */ .targetSecond != var5_5.targetSecond) {
                            while (!var6_6.isEmpty() && !var3_3.isEmpty() && ControlFlowHandler.is_hanger_resolvable(var0, var1_1, var3_3.peek(), var6_6.peek())) {
                                ControlFlowHandler.resolve_hanger(var0, var1_1, var2_2, var3_3.pop(), var6_6.peek());
                            }
                            ControlFlowHandler.resolve_else(var0, var2_2, var3_3, var4_4, (Branch)var13_16 /* !! */ , var5_5, var9_10);
                            var2_2.pop();
                        } else if (!ControlFlowHandler.splits_decl(var13_16 /* !! */ .line, var13_16 /* !! */ .targetFirst, var13_16 /* !! */ .targetSecond - 1, var1_1)) {
                            var5_5.targetSecond = var9_10;
                            var0.blocks.add(new IfThenElseBlock(var0.function, var13_16 /* !! */ .cond, var13_16 /* !! */ .targetFirst, var13_16 /* !! */ .targetSecond, var5_5.targetSecond, ControlFlowHandler.get_close_type(var0, var13_16 /* !! */ .targetSecond - 2), var13_16 /* !! */ .targetSecond - 2));
                            ControlFlowHandler.remove_branch(var0, var5_5);
                            var2_2.pop();
                        }
                    }
                    var11_14 = true;
                }
                if (!var11_14 && var12_15 != null && var7_8 + 1 < var0.branches.length && var0.branches[var7_8 + 1] != null && var0.branches[var7_8 + 1].type == Branch.Type.jump) {
                    for (var13_17 = 0; var13_17 < var3_3.size(); ++var13_17) {
                        var14_22 /* !! */  = var3_3.peek(var13_17);
                        if (!(var0.resolved[var14_22 /* !! */ .targetSecond] != var0.resolved[var12_15.end] || var7_8 + 1 >= var0.branches.length || var0.branches[var7_8 + 1] == null || var0.branches[var7_8 + 1].targetFirst != var14_22 /* !! */ .targetSecond || ControlFlowHandler.splits_decl(var14_22 /* !! */ .line, var14_22 /* !! */ .targetFirst, var5_5.line, var1_1) || ControlFlowHandler.splits_decl(var5_5.line, var5_5.line + 1, var5_5.line + 2, var1_1) || ControlFlowHandler.splits_decl(var14_22 /* !! */ .line, var14_22 /* !! */ .targetFirst, var5_5.line + 2, var1_1))) {
                            for (var15_23 = var13_17; var15_23 > 0; --var15_23) {
                                while (!ControlFlowHandler.is_hanger_resolvable(var0, var1_1, var3_3.peek(), var6_6.peek())) {
                                    var6_6.pop();
                                }
                                ControlFlowHandler.resolve_hanger(var0, var1_1, var2_2, var3_3.pop(), var6_6.peek());
                            }
                            var15_24 = var3_3.pop();
                            if (!var6_6.isEmpty() && var6_6.peek().targetFirst == var15_24.targetSecond) {
                                var6_6.pop();
                            }
                            var15_24.targetSecond = var7_8 + 1;
                            ControlFlowHandler.resolve_else(var0, var2_2, var3_3, var4_4, var15_24, var5_5, var9_10);
                            var11_14 = true;
                            break;
                        }
                        if (!ControlFlowHandler.is_hanger_resolvable(var0, var1_1, (Branch)var14_22 /* !! */ , var6_6)) break;
                    }
                }
                if (!var11_14 && var12_15 != null && var12_15.isSplitable() && var0.resolved[var5_5.targetFirst] == var12_15.getUnprotectedTarget() && var7_8 + 1 < var0.branches.length && var0.branches[var7_8 + 1] != null && var0.branches[var7_8 + 1].type == Branch.Type.jump && var0.resolved[var0.branches[var7_8 + 1].targetFirst] == var0.resolved[var12_15.end]) {
                    for (Block var17_27 : var13_18 = var12_15.split(var5_5.line, ControlFlowHandler.get_close_type(var0, var5_5.line - 1))) {
                        var0.blocks.add(var17_27);
                    }
                    ControlFlowHandler.remove_branch(var0, var5_5);
                    var11_14 = true;
                }
                if (!var11_14 && !var2_2.isEmpty() && var2_2.peek().targetSecond == var5_5.targetFirst && var7_8 + 1 < var0.branches.length && var0.branches[var7_8 + 1] != null && var0.branches[var7_8 + 1].type == Branch.Type.jump && var0.branches[var7_8 + 1].targetFirst == var5_5.targetFirst) {
                    var13_19 = var2_2.peek();
                    if (!ControlFlowHandler.splits_decl(var13_19.line, var13_19.targetFirst, var5_5.line, var1_1)) {
                        var13_19.targetSecond = var7_8 + 1;
                        var5_5.targetSecond = var7_8 + 1;
                        var0.blocks.add(new IfThenElseBlock(var0.function, var13_19.cond, var13_19.targetFirst, var13_19.targetSecond, var5_5.targetSecond, ControlFlowHandler.get_close_type(var0, var7_8 - 1), var7_8 - 1));
                        ControlFlowHandler.remove_branch(var0, var5_5);
                        var2_2.pop();
                    }
                    var11_14 = true;
                }
                if (!var11_14 && !var3_3.isEmpty() && var3_3.peek().targetSecond == var5_5.targetFirst && var7_8 + 1 < var0.branches.length && var0.branches[var7_8 + 1] != null && var0.branches[var7_8 + 1].type == Branch.Type.jump && var0.branches[var7_8 + 1].targetFirst == var5_5.targetFirst) {
                    var13_20 = var3_3.peek();
                    if (!ControlFlowHandler.splits_decl(var13_20.line, var13_20.targetFirst, var5_5.line, var1_1)) {
                        if (!var6_6.isEmpty() && var6_6.peek().targetFirst == var13_20.targetSecond) {
                            var6_6.pop();
                        }
                        var13_20.targetSecond = var7_8 + 1;
                        var5_5.targetSecond = var7_8 + 1;
                        var0.blocks.add(new IfThenElseBlock(var0.function, var13_20.cond, var13_20.targetFirst, var13_20.targetSecond, var5_5.targetSecond, ControlFlowHandler.get_close_type(var0, var7_8 - 1), var7_8 - 1));
                        ControlFlowHandler.remove_branch(var0, var5_5);
                        var3_3.pop();
                    }
                    var11_14 = true;
                }
                if (!var11_14 && (var0.function.header.version.usegoto.get().booleanValue() || var0.r.isNoDebug)) {
                    var13_21 = new Goto(var0.function, var5_5.line, var5_5.targetFirst);
                    if (!var3_3.isEmpty() && var3_3.peek().targetSecond == var5_5.targetFirst && ControlFlowHandler.enclosing_block(var0, var3_3.peek().line) == var8_9) {
                        var6_6.push(var5_5);
                    }
                    var0.blocks.add(var13_21);
                    var0.labels[var5_5.targetFirst] = true;
                    ControlFlowHandler.remove_branch(var0, var5_5);
                    var11_14 = true;
                }
            }
            var5_5 = var5_5.next;
        }
        while (!var6_6.isEmpty()) {
            ControlFlowHandler.resolve_hangers(var0, var1_1, var2_2, var3_3, (Branch)var6_6.pop());
        }
        while (!var3_3.isEmpty()) {
            block46: {
                block44: {
                    block45: {
                        var7_7 = (Branch)var3_3.pop();
                        var8_9 = ControlFlowHandler.enclosing_breakable_block(var0, var7_7.line);
                        if (var8_9 == null || var8_9.end != var7_7.targetSecond) break block44;
                        if (!var0.function.header.version.useifbreakrewrite.get().booleanValue() && !var0.r.isNoDebug) break block45;
                        var9_12 = new IfThenEndBlock(var0.function, var0.r, var7_7.cond.inverse(), var7_7.targetFirst - 1, var7_7.targetFirst - 1);
                        var9_12.addStatement(new Break(var0.function, var7_7.targetFirst - 1, var7_7.targetSecond));
                        var0.blocks.add(var9_12);
                        break block46;
                    }
                    throw new IllegalStateException();
                }
                if (!var0.function.header.version.usegoto.get().booleanValue() && !var0.r.isNoDebug) ** GOTO lbl170
                if (var0.function.header.version.useifbreakrewrite.get().booleanValue() || var0.r.isNoDebug) {
                    var9_12 = new IfThenEndBlock(var0.function, var0.r, var7_7.cond.inverse(), var7_7.targetFirst - 1, var7_7.targetFirst - 1);
                    var9_12.addStatement(new Goto(var0.function, var7_7.targetFirst - 1, var7_7.targetSecond));
                    var0.blocks.add(var9_12);
                    var0.labels[var7_7.targetSecond] = true;
                } else {
                    throw new IllegalStateException();
lbl170:
                    // 1 sources

                    throw new IllegalStateException();
                }
            }
            ControlFlowHandler.remove_branch(var0, var7_7);
        }
        while (ControlFlowHandler.resolve_if_stack(var0, var2_2, 0x7FFFFFFF) != null) {
        }
    }

    private static void unredirect_finalsets(State state, int n, int n2, int n3) {
        Branch branch = state.begin_branch;
        while (branch != null) {
            if (branch.type == Branch.Type.finalset && branch.targetSecond == n && branch.line < n2 && branch.line >= n3) {
                branch.targetFirst = n2 - 1;
                branch.targetSecond = n2;
                if (branch.finalset != null) {
                    branch.finalset.line = n2 - 1;
                }
            }
            branch = branch.next;
        }
    }

    private static void find_set_blocks(State state) {
        List<Block> list = state.blocks;
        Branch branch = state.begin_branch;
        while (branch != null) {
            if (ControlFlowHandler.is_assignment(branch) || branch.type == Branch.Type.finalset) {
                Object object;
                if (branch.finalset != null) {
                    object = branch.finalset;
                    Op op = state.code.op(((FinalSetCondition)object).line);
                    if (((FinalSetCondition)object).line >= 2 && (op == Op.MMBIN || op == Op.MMBINI || op == Op.MMBINK || op == Op.EXTRAARG)) {
                        --((FinalSetCondition)object).line;
                        if (branch.targetFirst == ((FinalSetCondition)object).line + 1) {
                            branch.targetFirst = ((FinalSetCondition)object).line;
                        }
                    }
                    while (state.code.isUpvalueDeclaration(((FinalSetCondition)object).line)) {
                        --((FinalSetCondition)object).line;
                        if (branch.targetFirst != ((FinalSetCondition)object).line + 1) continue;
                        branch.targetFirst = ((FinalSetCondition)object).line;
                    }
                    ((FinalSetCondition)object).type = ControlFlowHandler.is_jmp_raw(state, ((FinalSetCondition)object).line) ? FinalSetCondition.Type.REGISTER : FinalSetCondition.Type.VALUE;
                }
                if (branch.cond == branch.finalset) {
                    ControlFlowHandler.remove_branch(state, branch);
                } else {
                    object = new SetBlock(state.function, branch.cond, branch.target, branch.line, branch.targetFirst, branch.targetSecond, state.r);
                    list.add((Block)object);
                    ControlFlowHandler.remove_branch(state, branch);
                }
            }
            branch = branch.next;
        }
    }

    private static Block enclosing_block(State state, int n) {
        Block block = null;
        for (Block block2 : state.blocks) {
            if (!block2.contains(n) || block != null && !block.contains(block2)) continue;
            block = block2;
        }
        return block;
    }

    private static Block enclosing_breakable_block(State state, int n) {
        Block block = null;
        for (Block block2 : state.blocks) {
            if (!block2.contains(n) || !block2.breakable() || block != null && !block.contains(block2)) continue;
            block = block2;
        }
        return block;
    }

    private static Block enclosing_unprotected_block(State state, int n) {
        Block block = null;
        for (Block block2 : state.blocks) {
            if (!block2.contains(n) || !block2.isUnprotected() || block != null && !block.contains(block2)) continue;
            block = block2;
        }
        return block;
    }

    /*
     * WARNING - void declaration
     */
    private static void find_pseudo_goto_statements(State state, Declaration[] declarationArray) {
        Branch object = state.begin_branch;
        while (object != null) {
            if (object.type == Branch.Type.jump && object.targetFirst > object.line) {
                int n = object.targetFirst;
                Block object2 = null;
                for (Block object3 : state.blocks) {
                    if (!object3.contains(object.line) || !object3.contains(n - 1) || object2 != null && !object2.contains(object3)) continue;
                    object2 = object3;
                }
                if (object2 != null) {
                    int n2;
                    int n3;
                    Object object4 = null;
                    for (Block block : state.blocks) {
                        if (block == object2 || !object2.contains(block) || !block.contains(object.line) || object4 != null && !block.contains((Block)object4)) continue;
                        object4 = block;
                    }
                    int n4 = object2.begin;
                    if (object4 != null) {
                        int n5 = Math.max(((Block)object4).begin - 1, object2.begin);
                    }
                    int n6 = Integer.MIN_VALUE;
                    int n7 = Integer.MAX_VALUE;
                    for (Declaration declaration : declarationArray) {
                        if (declaration.end >= n3 && declaration.end <= n + -1 && declaration.begin < n3) {
                            n7 = Math.min(declaration.begin, n7);
                        }
                        if (declaration.begin < n3 || declaration.begin > n + -1 || declaration.end <= n + -1) continue;
                        n6 = Math.max(declaration.begin + 1, n6);
                        n3 = declaration.begin + 1;
                    }
                    if (n6 > n7) {
                        throw new IllegalStateException();
                    }
                    int n9 = Math.max(n6, n3);
                    n9 = Math.min(n7, n9);
                    Block block = ControlFlowHandler.enclosing_breakable_block(state, object.line);
                    if (block != null) {
                        n2 = Math.max(block.begin, n9);
                    }
                    int n10 = 0;
                    OnceLoop onceLoop = new OnceLoop(state.function, n2, n);
                    for (Block block2 : state.blocks) {
                        if (!onceLoop.contains(block2) || !(block2 instanceof Break)) continue;
                        n10 = 1;
                        break;
                    }
                    if (n10 != 0) {
                        state.blocks.add(new IfThenElseBlock(state.function, FixedCondition.TRUE, n2, object.line + 1, n, CloseType.NONE, -1));
                        state.blocks.add(new ElseEndBlock(state.function, object.line + 1, n, CloseType.NONE, -1));
                        ControlFlowHandler.remove_branch(state, object);
                    } else {
                        void var12_27;
                        state.blocks.add(onceLoop);
                        Branch branch = object;
                        while (var12_27 != null) {
                            if (var12_27.type == Branch.Type.jump && var12_27.targetFirst > var12_27.line && var12_27.targetFirst == object.targetFirst) {
                                Block block2;
                                block2 = new Break(state.function, var12_27.line, var12_27.targetFirst);
                                state.blocks.add(block2);
                                ((Break)block2).comment = "pseudo-goto";
                                ControlFlowHandler.remove_branch(state, (Branch)var12_27);
                                if (object.next == var12_27) {
                                    object = var12_27;
                                }
                            }
                            Branch branch2 = var12_27.next;
                        }
                    }
                }
            }
            object = object.next;
        }
    }

    private static void find_do_blocks(State state, Declaration[] declarationArray) {
        boolean bl;
        int n;
        ArrayList<DoEndBlock> arrayList = new ArrayList<DoEndBlock>();
        for (Block block : state.blocks) {
            int n2;
            Block object;
            if (!block.hasCloseLine() || block.getCloseLine() < 1 || (object = ControlFlowHandler.enclosing_block(state, n2 = block.getCloseLine())) != block && !object.contains(block) || !ControlFlowHandler.is_close(state, n2)) continue;
            n = ControlFlowHandler.get_close_value(state, n2);
            bl = true;
            Object object2 = null;
            for (Declaration declaration : declarationArray) {
                if (declaration.forLoop || declaration.forLoopExplicit || !block.contains(declaration.begin)) continue;
                if (declaration.register < n) {
                    bl = false;
                    continue;
                }
                if (declaration.register != n) continue;
                object2 = declaration;
            }
            if (bl) {
                block.useClose();
                continue;
            }
            if (object2 == null) continue;
            DoEndBlock doEndBlock = new DoEndBlock(state.function, ((Declaration)object2).begin, ((Declaration)object2).end + 1);
            doEndBlock.closeRegister = n;
            arrayList.add(doEndBlock);
            ControlFlowHandler.strictScopeCheck(state);
        }
        state.blocks.addAll(arrayList);
        for (Declaration declaration : declarationArray) {
            n = declaration.begin;
            if (declaration.forLoop || declaration.forLoopExplicit) continue;
            bl = true;
            for (Block block : state.blocks) {
                if (!block.contains(declaration.begin)) continue;
                if (block.scopeEnd() == declaration.end) {
                    block.useScope();
                    bl = false;
                    break;
                }
                if (block.scopeEnd() >= declaration.end) continue;
                n = Math.min(n, block.begin);
            }
            if (!bl) continue;
            state.blocks.add(new DoEndBlock(state.function, n, declaration.end + 1));
            ControlFlowHandler.strictScopeCheck(state);
        }
    }

    private static void strictScopeCheck(State state) {
        if (state.function.header.config.strict_scope) {
            throw new RuntimeException("Violation of strict scope rule");
        }
    }

    private static boolean is_conditional(Branch branch) {
        return branch.type == Branch.Type.comparison || branch.type == Branch.Type.test;
    }

    private static boolean is_assignment(Branch branch) {
        return branch.type == Branch.Type.testset;
    }

    private static boolean is_assignment(Branch branch, int n) {
        return branch.type == Branch.Type.testset || branch.type == Branch.Type.test && branch.target == n;
    }

    private static boolean adjacent(State state, Branch branch, Branch branch2) {
        boolean bl;
        if (branch2.finalset != null && branch.finalset == branch2.finalset) {
            return true;
        }
        if (branch == null || branch2 == null) {
            return false;
        }
        boolean bl2 = bl = branch.targetFirst <= branch2.line;
        if (bl) {
            bl = !ControlFlowHandler.has_statement(state, branch.targetFirst, branch2.line - 1);
            bl = bl && !state.reverse_targets[branch2.line];
        }
        return bl;
    }

    private static Branch combine_left(State state, Branch branch) {
        if (ControlFlowHandler.is_conditional(branch)) {
            return ControlFlowHandler.combine_conditional(state, branch);
        }
        if (ControlFlowHandler.is_assignment(branch) || branch.type == Branch.Type.finalset) {
            return ControlFlowHandler.combine_assignment(state, branch);
        }
        return branch;
    }

    private static Branch combine_conditional(State state, Branch branch) {
        Branch branch2 = branch.previous;
        Branch branch3 = branch;
        while (branch2 != null && branch2.line > branch.line) {
            branch2 = branch2.previous;
        }
        while (branch2 != null && branch3 == branch && ControlFlowHandler.adjacent(state, branch2, branch)) {
            branch3 = ControlFlowHandler.combine_conditional_helper(state, branch2, branch);
            if (branch2.targetSecond > branch.targetFirst) break;
            branch2 = branch2.previous;
        }
        return branch3;
    }

    private static Branch combine_conditional_helper(State state, Branch branch, Branch branch2) {
        if (ControlFlowHandler.is_conditional(branch) && ControlFlowHandler.is_conditional(branch2)) {
            int n = branch.targetSecond;
            if (ControlFlowHandler.is_jmp(state, branch2.targetFirst) && state.code.target(branch2.targetFirst) == n) {
                n = branch2.targetFirst;
            }
            if (n == branch2.targetFirst) {
                branch = ControlFlowHandler.combine_conditional(state, branch);
                OrCondition orCondition = new OrCondition(branch.cond.inverse(), branch2.cond);
                Branch branch3 = new Branch(branch.line, branch2.line2, Branch.Type.comparison, orCondition, branch2.targetFirst, branch2.targetSecond, branch2.finalset);
                branch3.inverseValue = branch2.inverseValue;
                if (verbose) {
                    System.err.println("conditional or " + branch3.line);
                }
                ControlFlowHandler.replace_branch(state, branch, branch2, branch3);
                return ControlFlowHandler.combine_conditional(state, branch3);
            }
            if (n == branch2.targetSecond) {
                branch = ControlFlowHandler.combine_conditional(state, branch);
                AndCondition andCondition = new AndCondition(branch.cond, branch2.cond);
                Branch branch4 = new Branch(branch.line, branch2.line2, Branch.Type.comparison, andCondition, branch2.targetFirst, branch2.targetSecond, branch2.finalset);
                branch4.inverseValue = branch2.inverseValue;
                if (verbose) {
                    System.err.println("conditional and " + branch4.line);
                }
                ControlFlowHandler.replace_branch(state, branch, branch2, branch4);
                return ControlFlowHandler.combine_conditional(state, branch4);
            }
        }
        return branch2;
    }

    private static Branch combine_assignment(State state, Branch branch) {
        Branch branch2 = branch.previous;
        Branch branch3 = branch;
        while (branch2 != null && branch3 == branch) {
            branch3 = ControlFlowHandler.combine_assignment_helper(state, branch2, branch);
            if (branch.cond != branch.finalset && branch2.cond != branch2.finalset && branch2.targetSecond > branch.targetFirst) break;
            branch2 = branch2.previous;
        }
        return branch3;
    }

    private static Branch combine_assignment_helper(State state, Branch branch, Branch branch2) {
        if (ControlFlowHandler.adjacent(state, branch, branch2)) {
            int n = branch2.target;
            if (branch2.target == -1) {
                throw new IllegalStateException();
            }
            if (ControlFlowHandler.is_conditional(branch) && ControlFlowHandler.is_assignment(branch2)) {
                if (branch.targetSecond == branch2.targetFirst) {
                    boolean bl = branch.inverseValue;
                    if (verbose) {
                        System.err.println("bridge " + (bl ? "or" : "and") + " " + branch2.line + " " + branch.line);
                    }
                    branch = ControlFlowHandler.combine_conditional(state, branch);
                    if (bl != branch.inverseValue) {
                        throw new IllegalStateException();
                    }
                    Condition condition = !branch2.inverseValue ? new OrCondition(branch.cond.inverse(), branch2.cond) : new AndCondition(branch.cond, branch2.cond);
                    Branch branch3 = new Branch(branch.line, branch2.line2, branch2.type, condition, branch2.targetFirst, branch2.targetSecond, branch2.finalset);
                    branch3.inverseValue = branch2.inverseValue;
                    branch3.target = n;
                    ControlFlowHandler.replace_branch(state, branch, branch2, branch3);
                    return ControlFlowHandler.combine_assignment(state, branch3);
                }
                if (branch.targetSecond == branch2.targetSecond) {
                    // empty if block
                }
            }
            if (ControlFlowHandler.is_assignment(branch, n) && ControlFlowHandler.is_assignment(branch2) && branch.inverseValue == branch2.inverseValue && branch.targetSecond == branch2.targetSecond) {
                if (verbose) {
                    System.err.println("assign " + (branch.inverseValue ? "or" : "and") + " " + branch2.line + " " + branch.line);
                }
                if (ControlFlowHandler.is_conditional(branch)) {
                    branch = ControlFlowHandler.combine_conditional(state, branch);
                    if (branch.inverseValue) {
                        branch.cond = branch.cond.inverse();
                    }
                } else {
                    boolean bl = branch.inverseValue;
                    branch = ControlFlowHandler.combine_assignment(state, branch);
                    if (bl != branch.inverseValue) {
                        throw new IllegalStateException();
                    }
                }
                Condition condition = branch.inverseValue ? new OrCondition(branch.cond, branch2.cond) : new AndCondition(branch.cond, branch2.cond);
                Branch branch4 = new Branch(branch.line, branch2.line2, branch2.type, condition, branch2.targetFirst, branch2.targetSecond, branch2.finalset);
                branch4.inverseValue = branch2.inverseValue;
                branch4.target = n;
                ControlFlowHandler.replace_branch(state, branch, branch2, branch4);
                return ControlFlowHandler.combine_assignment(state, branch4);
            }
            if (ControlFlowHandler.is_assignment(branch, n) && branch2.type == Branch.Type.finalset && branch.targetSecond == branch2.targetSecond) {
                if (branch.finalset != null && branch.finalset != branch2.finalset) {
                    Branch branch5 = branch.next;
                    while (branch5 != null) {
                        if (branch5.cond == branch.finalset) {
                            ControlFlowHandler.remove_branch(state, branch5);
                            break;
                        }
                        branch5 = branch5.next;
                    }
                }
                if (ControlFlowHandler.is_conditional(branch)) {
                    branch = ControlFlowHandler.combine_conditional(state, branch);
                    if (branch.inverseValue) {
                        branch.cond = branch.cond.inverse();
                    }
                } else {
                    boolean bl = branch.inverseValue;
                    branch = ControlFlowHandler.combine_assignment(state, branch);
                    if (bl != branch.inverseValue) {
                        throw new IllegalStateException();
                    }
                }
                if (verbose) {
                    System.err.println("final assign " + (branch.inverseValue ? "or" : "and") + " " + branch2.line + " " + branch.line);
                }
                Condition condition = branch.inverseValue ? new OrCondition(branch.cond, branch2.cond) : new AndCondition(branch.cond, branch2.cond);
                Branch branch6 = new Branch(branch.line, branch2.line2, Branch.Type.finalset, condition, branch2.targetFirst, branch2.targetSecond, branch2.finalset);
                branch6.target = n;
                ControlFlowHandler.replace_branch(state, branch, branch2, branch6);
                return ControlFlowHandler.combine_assignment(state, branch6);
            }
        }
        return branch2;
    }

    private static void raw_add_branch(State state, Branch branch) {
        if (branch.type == Branch.Type.finalset) {
            List<Branch> list = state.finalsetbranches.get(branch.line);
            if (list == null) {
                list = new LinkedList<Branch>();
                state.finalsetbranches.set(branch.line, list);
            }
            list.add(branch);
        } else if (branch.type == Branch.Type.testset) {
            state.setbranches[branch.line] = branch;
        } else {
            state.branches[branch.line] = branch;
        }
    }

    private static void raw_remove_branch(State state, Branch branch) {
        if (branch.type == Branch.Type.finalset) {
            List<Branch> list = state.finalsetbranches.get(branch.line);
            if (list == null) {
                throw new IllegalStateException();
            }
            list.remove(branch);
        } else if (branch.type == Branch.Type.testset) {
            state.setbranches[branch.line] = null;
        } else {
            state.branches[branch.line] = null;
        }
    }

    private static void replace_branch(State state, Branch branch, Branch branch2, Branch branch3) {
        ControlFlowHandler.remove_branch(state, branch);
        ControlFlowHandler.raw_remove_branch(state, branch2);
        branch3.previous = branch2.previous;
        if (branch3.previous == null) {
            state.begin_branch = branch3;
        } else {
            branch3.previous.next = branch3;
        }
        branch3.next = branch2.next;
        if (branch3.next == null) {
            state.end_branch = branch3;
        } else {
            branch3.next.previous = branch3;
        }
        ControlFlowHandler.raw_add_branch(state, branch3);
    }

    private static void remove_branch(State state, Branch branch) {
        ControlFlowHandler.raw_remove_branch(state, branch);
        Branch branch2 = branch.previous;
        Branch branch3 = branch.next;
        if (branch2 != null) {
            branch2.next = branch3;
        } else {
            state.begin_branch = branch3;
        }
        if (branch3 != null) {
            branch3.previous = branch2;
        } else {
            state.end_branch = branch2;
        }
    }

    private static void insert_branch(State state, Branch branch) {
        ControlFlowHandler.raw_add_branch(state, branch);
    }

    private static void link_branches(State state) {
        Branch branch = null;
        for (int i = 0; i < state.branches.length; ++i) {
            for (int j = 0; j < 3; ++j) {
                Branch[] branchArray;
                if (j == 0) {
                    branchArray = state.finalsetbranches.get(i);
                    if (branchArray == null) continue;
                    for (Branch branch2 : branchArray) {
                        branch2.previous = branch;
                        if (branch != null) {
                            branch.next = branch2;
                        } else {
                            state.begin_branch = branch2;
                        }
                        branch = branch2;
                    }
                    continue;
                }
                branchArray = j == 1 ? state.setbranches : state.branches;
                Branch branch3 = branchArray[i];
                if (branch3 == null) continue;
                branch3.previous = branch;
                if (branch != null) {
                    branch.next = branch3;
                } else {
                    state.begin_branch = branch3;
                }
                branch = branch3;
            }
        }
        state.end_branch = branch;
    }

    private static boolean is_jmp_raw(State state, int n) {
        Op op = state.code.op(n);
        return op == Op.JMP || op == Op.JMP52 || op == Op.JMP54;
    }

    private static boolean is_jmp(State state, int n) {
        Code code = state.code;
        Op op = code.op(n);
        if (op == Op.JMP || op == Op.JMP54) {
            return true;
        }
        if (op == Op.JMP52) {
            return !ControlFlowHandler.is_close(state, n);
        }
        return false;
    }

    private static boolean is_close(State state, int n) {
        Code code = state.code;
        Op op = code.op(n);
        if (op == Op.CLOSE) {
            return true;
        }
        if (op == Op.JMP52) {
            int n2 = code.target(n);
            if (n2 == n + 1) {
                return code.A(n) != 0;
            }
            if (n + 1 <= code.length && code.op(n + 1) == Op.JMP52) {
                return n2 == code.target(n + 1) && code.A(n) != 0;
            }
            return false;
        }
        return false;
    }

    private static int get_close_value(State state, int n) {
        Code code = state.code;
        Op op = code.op(n);
        if (op == Op.CLOSE) {
            return code.A(n);
        }
        if (op == Op.JMP52) {
            return code.A(n) - 1;
        }
        throw new IllegalStateException();
    }

    private static CloseType get_close_type(State state, int n) {
        if (n < 1 || !ControlFlowHandler.is_close(state, n)) {
            return CloseType.NONE;
        }
        Op op = state.code.op(n);
        if (op == Op.CLOSE) {
            return state.function.header.version.closesemantics.get() == Version.CloseSemantics.LUA54 ? CloseType.CLOSE54 : CloseType.CLOSE;
        }
        return CloseType.JMP;
    }

    private static boolean has_statement(State state, int n, int n2) {
        for (int i = n; i <= n2; ++i) {
            if (!ControlFlowHandler.is_statement(state, i)) continue;
            return true;
        }
        return state.d.hasStatement(n, n2);
    }

    private static boolean is_statement(State state, int n) {
        if (state.reverse_targets[n]) {
            return true;
        }
        Registers registers = state.r;
        if (!registers.getNewLocals(n).isEmpty()) {
            return true;
        }
        Code code = state.code;
        if (code.isUpvalueDeclaration(n)) {
            return false;
        }
        switch (code.op(n)) {
            case TESTSET: 
            case TESTSET54: 
            case MOVE: 
            case LOADI: 
            case LOADF: 
            case LOADK: 
            case LOADKX: 
            case LOADBOOL: 
            case LOADFALSE: 
            case LOADTRUE: 
            case LFALSESKIP: 
            case GETGLOBAL: 
            case GETUPVAL: 
            case GETTABUP: 
            case GETTABUP54: 
            case GETTABLE: 
            case GETTABLE54: 
            case GETI: 
            case GETFIELD: 
            case NEWTABLE50: 
            case NEWTABLE: 
            case NEWTABLE54: 
            case ADD: 
            case SUB: 
            case MUL: 
            case DIV: 
            case IDIV: 
            case MOD: 
            case POW: 
            case BAND: 
            case BOR: 
            case BXOR: 
            case SHL: 
            case SHR: 
            case UNM: 
            case NOT: 
            case LEN: 
            case BNOT: 
            case CONCAT: 
            case CONCAT54: 
            case CLOSURE: {
                return registers.isLocal(code.A(n), n);
            }
            case ADD54: 
            case SUB54: 
            case MUL54: 
            case DIV54: 
            case IDIV54: 
            case MOD54: 
            case POW54: 
            case BAND54: 
            case BOR54: 
            case BXOR54: 
            case SHL54: 
            case SHR54: 
            case ADDK: 
            case SUBK: 
            case MULK: 
            case DIVK: 
            case IDIVK: 
            case MODK: 
            case POWK: 
            case BANDK: 
            case BORK: 
            case BXORK: 
            case ADDI: 
            case SHLI: 
            case SHRI: {
                return false;
            }
            case MMBIN: 
            case MMBINI: 
            case MMBINK: {
                if (n <= 1) {
                    throw new IllegalStateException();
                }
                return registers.isLocal(code.A(n - 1), n - 1);
            }
            case LOADNIL: {
                for (int i = code.A(n); i <= code.B(n); ++i) {
                    if (!registers.isLocal(i, n)) continue;
                    return true;
                }
                return false;
            }
            case LOADNIL52: {
                for (int i = code.A(n); i <= code.A(n) + code.B(n); ++i) {
                    if (!registers.isLocal(i, n)) continue;
                    return true;
                }
                return false;
            }
            case FORPREP: 
            case FORPREP54: 
            case TFORPREP: 
            case TFORPREP54: 
            case SETGLOBAL: 
            case SETUPVAL: 
            case SETTABUP: 
            case SETTABUP54: 
            case TAILCALL: 
            case TAILCALL54: 
            case RETURN: 
            case RETURN54: 
            case RETURN0: 
            case RETURN1: 
            case FORLOOP: 
            case FORLOOP54: 
            case TFORCALL: 
            case TFORCALL54: 
            case TFORLOOP: 
            case TFORLOOP52: 
            case TFORLOOP54: 
            case CLOSE: 
            case TBC: {
                return true;
            }
            case TEST50: {
                return code.A(n) != code.B(n) && registers.isLocal(code.A(n), n);
            }
            case SELF: 
            case SELF54: {
                return registers.isLocal(code.A(n), n) || registers.isLocal(code.A(n) + 1, n);
            }
            case EQ: 
            case LT: 
            case LE: 
            case EQ54: 
            case LT54: 
            case LE54: 
            case EQK: 
            case EQI: 
            case LTI: 
            case LEI: 
            case GTI: 
            case GEI: 
            case TEST: 
            case TEST54: 
            case SETLIST50: 
            case SETLISTO: 
            case SETLIST: 
            case SETLIST52: 
            case SETLIST54: 
            case VARARGPREP: 
            case EXTRAARG: 
            case EXTRABYTE: {
                return false;
            }
            case JMP: 
            case JMP52: 
            case JMP54: {
                Op op;
                if (n == 1) {
                    return true;
                }
                Op op2 = n >= 2 ? code.op(n - 1) : null;
                Op op3 = op = n + 1 <= code.length ? code.op(n + 1) : null;
                if (op2 == Op.EQ) {
                    return false;
                }
                if (op2 == Op.LT) {
                    return false;
                }
                if (op2 == Op.LE) {
                    return false;
                }
                if (op2 == Op.EQ54) {
                    return false;
                }
                if (op2 == Op.LT54) {
                    return false;
                }
                if (op2 == Op.LE54) {
                    return false;
                }
                if (op2 == Op.EQK) {
                    return false;
                }
                if (op2 == Op.EQI) {
                    return false;
                }
                if (op2 == Op.LTI) {
                    return false;
                }
                if (op2 == Op.LEI) {
                    return false;
                }
                if (op2 == Op.GTI) {
                    return false;
                }
                if (op2 == Op.GEI) {
                    return false;
                }
                if (op2 == Op.TEST50) {
                    return false;
                }
                if (op2 == Op.TEST) {
                    return false;
                }
                if (op2 == Op.TEST54) {
                    return false;
                }
                if (op2 == Op.TESTSET) {
                    return false;
                }
                if (op2 == Op.TESTSET54) {
                    return false;
                }
                if (op == Op.LOADBOOL && code.C(n + 1) != 0) {
                    return false;
                }
                return op != Op.LFALSESKIP;
            }
            case CALL: {
                int n2 = code.A(n);
                int n3 = code.C(n);
                if (n3 == 1) {
                    return true;
                }
                if (n3 == 0) {
                    n3 = registers.registers - n2 + 1;
                }
                for (int i = n2; i < n2 + n3 - 1; ++i) {
                    if (!registers.isLocal(i, n)) continue;
                    return true;
                }
                return false;
            }
            case VARARG: {
                int n4 = code.A(n);
                int n5 = code.B(n);
                if (n5 == 0) {
                    n5 = registers.registers - n4 + 1;
                }
                for (int i = n4; i < n4 + n5 - 1; ++i) {
                    if (!registers.isLocal(i, n)) continue;
                    return true;
                }
                return false;
            }
            case VARARG54: {
                int n6 = code.A(n);
                int n7 = code.C(n);
                if (n7 == 0) {
                    n7 = registers.registers - n6 + 1;
                }
                for (int i = n6; i < n6 + n7 - 1; ++i) {
                    if (!registers.isLocal(i, n)) continue;
                    return true;
                }
                return false;
            }
            case SETTABLE: 
            case SETTABLE54: 
            case SETI: 
            case SETFIELD: {
                return false;
            }
            case DEFAULT: 
            case DEFAULT54: {
                throw new IllegalStateException();
            }
        }
        throw new IllegalStateException("Illegal opcode: " + String.valueOf((Object)code.op(n)));
    }

    private ControlFlowHandler() {
    }

    private static class State {
        public Decompiler d;
        public LFunction function;
        public Registers r;
        public Code code;
        public Branch begin_branch;
        public Branch end_branch;
        public Branch[] branches;
        public Branch[] setbranches;
        public ArrayList<List<Branch>> finalsetbranches;
        public boolean[] reverse_targets;
        public int[] resolved;
        public boolean[] labels;
        public List<Block> blocks;

        private State() {
        }
    }

    public static class Result {
        public List<Block> blocks;
        public boolean[] labels;

        public Result(State state) {
            this.blocks = state.blocks;
            this.labels = state.labels;
        }
    }

    private static class Branch
    implements Comparable<Branch> {
        public Branch previous;
        public Branch next;
        public int line;
        public int line2;
        public int target;
        public Type type;
        public Condition cond;
        public int targetFirst;
        public int targetSecond;
        public boolean inverseValue;
        public FinalSetCondition finalset;

        public Branch(int n, int n2, Type type, Condition condition, int n3, int n4, FinalSetCondition finalSetCondition) {
            this.line = n;
            this.line2 = n2;
            this.type = type;
            this.cond = condition;
            this.targetFirst = n3;
            this.targetSecond = n4;
            this.inverseValue = false;
            this.target = -1;
            this.finalset = finalSetCondition;
        }

        @Override
        public int compareTo(Branch branch) {
            return this.line - branch.line;
        }

        private static enum Type {
            comparison,
            test,
            testset,
            finalset,
            jump;

        }
    }
}

