/*
 * Decompiled with CFR 0.152.
 */
package unluac.decompile;

import unluac.Version;
import unluac.decompile.Decompiler;
import unluac.decompile.Output;
import unluac.parse.LBoolean;
import unluac.parse.LNil;
import unluac.parse.LNumber;
import unluac.parse.LObject;
import unluac.parse.LString;

public class Constant {
    private final Type type;
    private final boolean bool;
    private final LNumber number;
    private final String string;

    public Constant(int n) {
        this.type = Type.NUMBER;
        this.bool = false;
        this.number = LNumber.makeInteger(n);
        this.string = null;
    }

    public Constant(double d) {
        this.type = Type.NUMBER;
        this.bool = false;
        this.number = LNumber.makeDouble(d);
        this.string = null;
    }

    public Constant(LObject lObject) {
        if (lObject instanceof LNil) {
            this.type = Type.NIL;
            this.bool = false;
            this.number = null;
            this.string = null;
        } else if (lObject instanceof LBoolean) {
            this.type = Type.BOOLEAN;
            this.bool = lObject == LBoolean.LTRUE;
            this.number = null;
            this.string = null;
        } else if (lObject instanceof LNumber) {
            this.type = Type.NUMBER;
            this.bool = false;
            this.number = (LNumber)lObject;
            this.string = null;
        } else if (lObject instanceof LString) {
            this.type = Type.STRING;
            this.bool = false;
            this.number = null;
            this.string = ((LString)lObject).deref();
        } else {
            throw new IllegalArgumentException("Illegal constant type: " + lObject.toString());
        }
    }

    public void print(Decompiler decompiler, Output output, boolean bl) {
        switch (this.type.ordinal()) {
            case 0: {
                output.print("nil");
                break;
            }
            case 1: {
                output.print(this.bool ? "true" : "false");
                break;
            }
            case 2: {
                output.print(this.number.toPrintString(0));
                break;
            }
            case 3: {
                int n;
                int n2;
                int n3 = 0;
                int n4 = 0;
                boolean bl2 = decompiler.getConfiguration().rawstring;
                for (n2 = 0; n2 < this.string.length(); ++n2) {
                    n = this.string.charAt(n2);
                    if (n == 10) {
                        ++n3;
                        continue;
                    }
                    if ((n > 31 || n == 9) && n < 127) continue;
                    ++n4;
                }
                n2 = n3 > 1 || n3 == 1 && this.string.indexOf(10) != this.string.length() - 1 ? 1 : 0;
                n2 = n2 != 0 && n4 == 0 ? 1 : 0;
                int n5 = n2 = n2 != 0 && !this.string.contains("[[") ? 1 : 0;
                if (decompiler.function.header.version.usenestinglongstrings.get().booleanValue()) {
                    int n6 = n2 = n2 != 0 && !this.string.contains("]]") && !this.string.endsWith("]") ? 1 : 0;
                }
                if (n2 != 0) {
                    int n7;
                    n = 0;
                    Object object = "]]";
                    String string = "]";
                    while (this.string.endsWith(string) || this.string.indexOf((String)object) >= 0) {
                        object = "]";
                        n7 = ++n;
                        while (n7-- > 0) {
                            object = (String)object + "=";
                        }
                        string = object;
                        object = (String)object + "]";
                    }
                    if (bl) {
                        output.print("(");
                    }
                    output.print("[");
                    while (n-- > 0) {
                        output.print("=");
                    }
                    output.print("[");
                    n7 = output.getIndentationLevel();
                    output.setIndentationLevel(0);
                    output.println();
                    output.print(this.string);
                    output.print((String)object);
                    if (bl) {
                        output.print(")");
                    }
                    output.setIndentationLevel(n7);
                    break;
                }
                output.print("\"");
                for (n = 0; n < this.string.length(); ++n) {
                    char c = this.string.charAt(n);
                    if (c <= '\u001f' || c >= '\u007f') {
                        if (c == '\u0007') {
                            output.print("\\a");
                            continue;
                        }
                        if (c == '\b') {
                            output.print("\\b");
                            continue;
                        }
                        if (c == '\f') {
                            output.print("\\f");
                            continue;
                        }
                        if (c == '\n') {
                            output.print("\\n");
                            continue;
                        }
                        if (c == '\r') {
                            output.print("\\r");
                            continue;
                        }
                        if (c == '\t') {
                            output.print("\\t");
                            continue;
                        }
                        if (c == '\u000b') {
                            output.print("\\v");
                            continue;
                        }
                        if (!bl2 || c <= '\u007f') {
                            String string = Integer.toString(c);
                            int n8 = string.length();
                            output.print("\\");
                            while (n8++ < 3) {
                                output.print("0");
                            }
                            output.print(string);
                            continue;
                        }
                        output.print((byte)c);
                        continue;
                    }
                    if (c == '\"') {
                        output.print("\\\"");
                        continue;
                    }
                    if (c == '\\') {
                        output.print("\\\\");
                        continue;
                    }
                    output.print(Character.toString(c));
                }
                output.print("\"");
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
    }

    public boolean isNil() {
        return this.type == Type.NIL;
    }

    public boolean isBoolean() {
        return this.type == Type.BOOLEAN;
    }

    public boolean isNumber() {
        return this.type == Type.NUMBER;
    }

    public boolean isInteger() {
        return this.number.value() == (double)Math.round(this.number.value());
    }

    public boolean isNegative() {
        return String.valueOf(this.number.value()).startsWith("-");
    }

    public int asInteger() {
        if (!this.isInteger()) {
            throw new IllegalStateException();
        }
        return (int)this.number.value();
    }

    public boolean isString() {
        return this.type == Type.STRING;
    }

    public boolean isIdentifierPermissive(Version version) {
        if (!this.isString() || version.isReserved(this.string)) {
            return false;
        }
        if (this.string.length() == 0) {
            return false;
        }
        char c = this.string.charAt(0);
        return !Character.isDigit(c) || c == ' ' || Character.isLetter(c);
    }

    public boolean isIdentifier(Version version) {
        if (!this.isIdentifierPermissive(version)) {
            return false;
        }
        char c = this.string.charAt(0);
        if (c != '_' && !Character.isLetter(c)) {
            return false;
        }
        for (int i = 1; i < this.string.length(); ++i) {
            char c2 = this.string.charAt(i);
            if (Character.isLetter(c2) || Character.isDigit(c2) || c2 == '_') continue;
            return false;
        }
        return true;
    }

    public String asName() {
        if (this.type != Type.STRING) {
            throw new IllegalStateException();
        }
        return this.string;
    }

    private static enum Type {
        NIL,
        BOOLEAN,
        NUMBER,
        STRING;

    }
}

