/*
 * Decompiled with CFR 0.152.
 */
package unluac.decompile;

import unluac.Version;

public class CodeExtract {
    public final Field op;
    public final Field A;
    public final Field B;
    public final Field C;
    public final Field k;
    public final Field Ax;
    public final Field sJ;
    public final Field Bx;
    public final Field sBx;
    public final Field x;
    private final int rk_offset;

    public CodeExtract(Version version, int n, int n2, int n3, int n4) {
        switch (version.instructionformat.get()) {
            case LUA50: {
                this.op = new Field(n, 0);
                this.A = new Field(n2, n3 + n4 + n);
                this.B = new Field(n3, n3 + n);
                this.C = new Field(n4, n);
                this.k = null;
                this.Ax = null;
                this.sJ = null;
                this.Bx = new Field(n3 + n4, n);
                this.sBx = new Field(n3 + n4, n, CodeExtract.size_to_mask(n3 + n4) / 2);
                this.x = new Field(32, 0);
                break;
            }
            case LUA51: {
                this.op = new Field(6, 0);
                this.A = new Field(8, 6);
                this.B = new Field(9, 23);
                this.C = new Field(9, 14);
                this.k = null;
                this.Ax = new Field(26, 6);
                this.sJ = null;
                this.Bx = new Field(18, 14);
                this.sBx = new Field(18, 14, 131071);
                this.x = new Field(32, 0);
                break;
            }
            case LUA54: {
                this.op = new Field(7, 0);
                this.A = new Field(8, 7);
                this.B = new Field(8, 16);
                this.C = new Field(8, 24);
                this.k = new Field(1, 15);
                this.Ax = new Field(25, 7);
                this.sJ = new Field(25, 7, 0xFFFFFF);
                this.Bx = new Field(17, 15);
                this.sBx = new Field(17, 15, 65535);
                this.x = new Field(32, 0);
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        Integer n5 = version.rkoffset.get();
        this.rk_offset = n5 == null ? -1 : n5;
    }

    public boolean is_k(int n) {
        return n >= this.rk_offset;
    }

    public int get_k(int n) {
        return n - this.rk_offset;
    }

    public int encode_k(int n) {
        return n + this.rk_offset;
    }

    private static int size_to_mask(int n) {
        return (int)((1L << n) - 1L);
    }

    public static class Field {
        public final int size;
        private final int shift;
        private final int mask;
        private final int offset;

        public Field(int n, int n2) {
            this(n, n2, 0);
        }

        public Field(int n, int n2, int n3) {
            this.size = n;
            this.shift = n2;
            this.mask = CodeExtract.size_to_mask(n);
            this.offset = n3;
        }

        public int extract(int n) {
            return (n >>> this.shift & this.mask) - this.offset;
        }

        public boolean check(int n) {
            return (n + this.offset & ~this.mask) == 0;
        }

        public int encode(int n) {
            return n + this.offset << this.shift;
        }

        public int clear(int n) {
            return n & ~(this.mask << this.shift);
        }

        public int max() {
            return this.mask - this.offset;
        }
    }
}

