/*
 * Decompiled with CFR 0.152.
 */
package unluac.decompile;

import unluac.Version;
import unluac.decompile.CodeExtract;
import unluac.decompile.Op;
import unluac.decompile.OpcodeMap;
import unluac.parse.LFunction;

public class Code {
    private final CodeExtract extractor;
    private final OpcodeMap map;
    private final int[] code;
    private final boolean[] extraByte;
    private final boolean[] upvalue;
    public final int length;

    public Code(LFunction lFunction) {
        int n;
        int n2;
        this.code = lFunction.code;
        this.length = this.code.length;
        this.map = lFunction.header.opmap;
        this.extractor = lFunction.header.extractor;
        this.extraByte = new boolean[this.length];
        for (n2 = 0; n2 < this.length; ++n2) {
            n = n2 + 1;
            Op op = this.op(n);
            this.extraByte[n2] = op != null && op.hasExtraByte(this.codepoint(n), this.extractor);
        }
        this.upvalue = new boolean[this.length];
        if (lFunction.header.version.upvaluedeclarationtype.get() == Version.UpvalueDeclarationType.INLINE) {
            for (n2 = 0; n2 < this.length; ++n2) {
                int n3;
                n = n2 + 1;
                if (this.op(n) != Op.CLOSURE || (n3 = this.Bx(n)) >= lFunction.functions.length) continue;
                int n4 = lFunction.functions[n3].numUpvalues;
                for (int i = 1; i <= n4; ++i) {
                    if (n2 + i >= this.length) continue;
                    this.upvalue[n2 + i] = true;
                }
            }
        }
    }

    public CodeExtract getExtractor() {
        return this.extractor;
    }

    public Op op(int n) {
        if (n >= 2 && this.extraByte[n - 2]) {
            return Op.EXTRABYTE;
        }
        return this.map.get(this.opcode(n));
    }

    public int opcode(int n) {
        return this.extractor.op.extract(this.code[n - 1]);
    }

    public int A(int n) {
        return this.extractor.A.extract(this.code[n - 1]);
    }

    public int C(int n) {
        return this.extractor.C.extract(this.code[n - 1]);
    }

    public int sC(int n) {
        int n2 = this.C(n);
        return n2 - this.extractor.C.max() / 2;
    }

    public boolean k(int n) {
        return this.extractor.k.extract(this.code[n - 1]) != 0;
    }

    public int B(int n) {
        return this.extractor.B.extract(this.code[n - 1]);
    }

    public int sB(int n) {
        int n2 = this.B(n);
        return n2 - this.extractor.B.max() / 2;
    }

    public int Ax(int n) {
        return this.extractor.Ax.extract(this.code[n - 1]);
    }

    public int Bx(int n) {
        return this.extractor.Bx.extract(this.code[n - 1]);
    }

    public int sBx(int n) {
        return this.extractor.sBx.extract(this.code[n - 1]);
    }

    public int target(int n) {
        return n + 1 + this.op(n).jumpField(this.codepoint(n), this.extractor);
    }

    public int register(int n) {
        return this.op(n).target(this.codepoint(n), this.extractor);
    }

    public int codepoint(int n) {
        return this.code[n - 1];
    }

    public boolean isUpvalueDeclaration(int n) {
        return this.upvalue[n - 1];
    }

    public int length() {
        return this.code.length;
    }

    public String toString(int n) {
        return this.op(n).codePointToString(0, null, this.codepoint(n), this.extractor, null, false);
    }
}

