/*
 * Decompiled with CFR 0.152.
 */
package unluac.assemble;

import java.util.HashMap;
import java.util.Map;
import unluac.assemble.DirectiveType;
import unluac.decompile.Output;
import unluac.parse.BHeader;
import unluac.parse.LFunction;
import unluac.parse.LHeader;

public enum Directive {
    FORMAT(".format", DirectiveType.HEADER, 1),
    ENDIANNESS(".endianness", DirectiveType.HEADER, 1),
    INT_SIZE(".int_size", DirectiveType.HEADER, 1),
    SIZE_T_SIZE(".size_t_size", DirectiveType.HEADER, 1),
    INSTRUCTION_SIZE(".instruction_size", DirectiveType.HEADER, 1),
    SIZE_OP(".size_op", DirectiveType.HEADER, 1),
    SIZE_A(".size_a", DirectiveType.HEADER, 1),
    SIZE_B(".size_b", DirectiveType.HEADER, 1),
    SIZE_C(".size_c", DirectiveType.HEADER, 1),
    NUMBER_FORMAT(".number_format", DirectiveType.HEADER, 2),
    INTEGER_FORMAT(".integer_format", DirectiveType.HEADER, 1),
    FLOAT_FORMAT(".float_format", DirectiveType.HEADER, 1),
    TYPE(".type", DirectiveType.HEADER, 2, true),
    OP(".op", DirectiveType.HEADER, 2, true),
    FUNCTION(".function", DirectiveType.NEWFUNCTION, 1),
    SOURCE(".source", DirectiveType.FUNCTION, 1),
    LINEDEFINED(".linedefined", DirectiveType.FUNCTION, 1),
    LASTLINEDEFINED(".lastlinedefined", DirectiveType.FUNCTION, 1),
    NUMPARAMS(".numparams", DirectiveType.FUNCTION, 1),
    IS_VARARG(".is_vararg", DirectiveType.FUNCTION, 1),
    MAXSTACKSIZE(".maxstacksize", DirectiveType.FUNCTION, 1),
    LABEL(".label", DirectiveType.FUNCTION, 1),
    CONSTANT(".constant", DirectiveType.FUNCTION, 2),
    LINE(".line", DirectiveType.FUNCTION, 1),
    ABSLINEINFO(".abslineinfo", DirectiveType.FUNCTION, 2),
    LOCAL(".local", DirectiveType.FUNCTION, 3),
    UPVALUE(".upvalue", DirectiveType.FUNCTION, 2);

    public final String token;
    public final DirectiveType type;
    public final boolean repeatable;
    static Map<String, Directive> lookup;

    private Directive(String string2, DirectiveType directiveType, int n2) {
        this(string2, directiveType, n2, false);
    }

    private Directive(String string2, DirectiveType directiveType, int n2, boolean bl) {
        this.token = string2;
        this.type = directiveType;
        this.repeatable = bl;
    }

    public void disassemble(Output output, BHeader bHeader, LHeader lHeader) {
        output.print(this.token + "\t");
        switch (this.ordinal()) {
            case 0: {
                output.println(String.valueOf(lHeader.format));
                break;
            }
            case 1: {
                output.println(lHeader.endianness.toString());
                break;
            }
            case 2: {
                output.println(String.valueOf(lHeader.integer.getSize()));
                break;
            }
            case 3: {
                output.println(String.valueOf(lHeader.sizeT.getSize()));
                break;
            }
            case 4: {
                output.println("4");
                break;
            }
            case 5: {
                output.println(String.valueOf(lHeader.extractor.op.size));
                break;
            }
            case 6: {
                output.println(String.valueOf(lHeader.extractor.A.size));
                break;
            }
            case 7: {
                output.println(String.valueOf(lHeader.extractor.B.size));
                break;
            }
            case 8: {
                output.println(String.valueOf(lHeader.extractor.C.size));
                break;
            }
            case 9: {
                output.println((lHeader.number.integral ? "integer" : "float") + "\t" + lHeader.number.size);
                break;
            }
            case 10: {
                output.println(String.valueOf(lHeader.linteger.size));
                break;
            }
            case 11: {
                output.println(String.valueOf(lHeader.lfloat.size));
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
    }

    public void disassemble(Output output, BHeader bHeader, LFunction lFunction, int n) {
        output.print(this.token + "\t");
        switch (this.ordinal()) {
            case 15: {
                output.println(lFunction.name.toPrintString(n));
                break;
            }
            case 16: {
                output.println(String.valueOf(lFunction.linedefined));
                break;
            }
            case 17: {
                output.println(String.valueOf(lFunction.lastlinedefined));
                break;
            }
            case 18: {
                output.println(String.valueOf(lFunction.numParams));
                break;
            }
            case 19: {
                output.println(String.valueOf(lFunction.vararg));
                break;
            }
            case 20: {
                output.println(String.valueOf(lFunction.maximumStackSize));
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
    }

    static {
        lookup = new HashMap<String, Directive>();
        for (Directive directive : Directive.values()) {
            lookup.put(directive.token, directive);
        }
    }
}

