/*
 * Decompiled with CFR 0.152.
 */
package unluac.assemble;

import java.io.IOException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import unluac.assemble.Assembler;
import unluac.assemble.AssemblerAbsLineInfo;
import unluac.assemble.AssemblerChunk;
import unluac.assemble.AssemblerConstant;
import unluac.assemble.AssemblerException;
import unluac.assemble.AssemblerLabel;
import unluac.assemble.AssemblerLocal;
import unluac.assemble.AssemblerUpvalue;
import unluac.assemble.Directive;
import unluac.decompile.CodeExtract;
import unluac.decompile.Op;
import unluac.decompile.OperandFormat;
import unluac.util.StringUtils;

class AssemblerFunction {
    public AssemblerChunk chunk;
    public AssemblerFunction parent;
    public String name;
    public List<AssemblerFunction> children;
    public boolean hasSource;
    public String source;
    public boolean hasLineDefined;
    public int linedefined;
    public boolean hasLastLineDefined;
    public int lastlinedefined;
    public boolean hasMaxStackSize;
    public int maxStackSize;
    public boolean hasNumParams;
    public int numParams;
    public boolean hasVararg;
    public int vararg;
    public List<AssemblerLabel> labels;
    public List<AssemblerConstant> constants;
    public List<AssemblerUpvalue> upvalues;
    public List<Integer> code;
    public List<Integer> lines;
    public List<AssemblerAbsLineInfo> abslineinfo;
    public List<AssemblerLocal> locals;
    public List<FunctionFixup> f_fixup;
    public List<JumpFixup> j_fixup;

    public AssemblerFunction(AssemblerChunk assemblerChunk, AssemblerFunction assemblerFunction, String string) {
        this.chunk = assemblerChunk;
        this.parent = assemblerFunction;
        this.name = string;
        this.children = new ArrayList<AssemblerFunction>();
        this.hasSource = false;
        this.hasLineDefined = false;
        this.hasLastLineDefined = false;
        this.hasMaxStackSize = false;
        this.hasNumParams = false;
        this.hasVararg = false;
        this.labels = new ArrayList<AssemblerLabel>();
        this.constants = new ArrayList<AssemblerConstant>();
        this.upvalues = new ArrayList<AssemblerUpvalue>();
        this.code = new ArrayList<Integer>();
        this.lines = new ArrayList<Integer>();
        this.abslineinfo = new ArrayList<AssemblerAbsLineInfo>();
        this.locals = new ArrayList<AssemblerLocal>();
        this.f_fixup = new ArrayList<FunctionFixup>();
        this.j_fixup = new ArrayList<JumpFixup>();
    }

    public AssemblerFunction addChild(String string) {
        AssemblerFunction assemblerFunction = new AssemblerFunction(this.chunk, this, string);
        this.children.add(assemblerFunction);
        return assemblerFunction;
    }

    public AssemblerFunction getInnerParent(String[] stringArray, int n) throws AssemblerException {
        if (n + 1 == stringArray.length) {
            return this;
        }
        for (AssemblerFunction assemblerFunction : this.children) {
            if (!assemblerFunction.name.equals(stringArray[n])) continue;
            return assemblerFunction.getInnerParent(stringArray, n + 1);
        }
        throw new AssemblerException("Can't find outer function");
    }

    public void processFunctionDirective(Assembler assembler, Directive directive) throws AssemblerException, IOException {
        switch (directive) {
            case SOURCE: {
                if (this.hasSource) {
                    throw new AssemblerException("Duplicate .source directive");
                }
                this.hasSource = true;
                this.source = assembler.getString();
                break;
            }
            case LINEDEFINED: {
                if (this.hasLineDefined) {
                    throw new AssemblerException("Duplicate .linedefined directive");
                }
                this.hasLineDefined = true;
                this.linedefined = assembler.getInteger();
                break;
            }
            case LASTLINEDEFINED: {
                if (this.hasLastLineDefined) {
                    throw new AssemblerException("Duplicate .lastlinedefined directive");
                }
                this.hasLastLineDefined = true;
                this.lastlinedefined = assembler.getInteger();
                break;
            }
            case MAXSTACKSIZE: {
                if (this.hasMaxStackSize) {
                    throw new AssemblerException("Duplicate .maxstacksize directive");
                }
                this.hasMaxStackSize = true;
                this.maxStackSize = assembler.getInteger();
                break;
            }
            case NUMPARAMS: {
                if (this.hasNumParams) {
                    throw new AssemblerException("Duplicate .numparams directive");
                }
                this.hasNumParams = true;
                this.numParams = assembler.getInteger();
                break;
            }
            case IS_VARARG: {
                if (this.hasVararg) {
                    throw new AssemblerException("Duplicate .is_vararg directive");
                }
                this.hasVararg = true;
                this.vararg = assembler.getInteger();
                break;
            }
            case LABEL: {
                String string = assembler.getAny();
                AssemblerLabel assemblerLabel = new AssemblerLabel();
                assemblerLabel.name = string;
                assemblerLabel.code_index = this.code.size();
                this.labels.add(assemblerLabel);
                break;
            }
            case CONSTANT: {
                String string = assembler.getName();
                String string2 = assembler.getAny();
                AssemblerConstant assemblerConstant = new AssemblerConstant();
                assemblerConstant.name = string;
                if (string2.equals("nil")) {
                    assemblerConstant.type = AssemblerConstant.Type.NIL;
                } else if (string2.equals("true")) {
                    assemblerConstant.type = AssemblerConstant.Type.BOOLEAN;
                    assemblerConstant.booleanValue = true;
                } else if (string2.equals("false")) {
                    assemblerConstant.type = AssemblerConstant.Type.BOOLEAN;
                    assemblerConstant.booleanValue = false;
                } else if (string2.startsWith("\"")) {
                    assemblerConstant.type = AssemblerConstant.Type.STRING;
                    assemblerConstant.stringValue = StringUtils.fromPrintString(string2);
                } else if (string2.startsWith("L\"")) {
                    assemblerConstant.type = AssemblerConstant.Type.LONGSTRING;
                    assemblerConstant.stringValue = StringUtils.fromPrintString(string2.substring(1));
                } else if (string2.equals("null")) {
                    assemblerConstant.type = AssemblerConstant.Type.STRING;
                    assemblerConstant.stringValue = null;
                } else if (string2.equals("NaN")) {
                    assemblerConstant.type = AssemblerConstant.Type.NAN;
                    assemblerConstant.nanValue = 0L;
                } else {
                    try {
                        if (string2.startsWith("NaN+") || string2.startsWith("NaN-")) {
                            long l = Long.parseUnsignedLong(string2.substring(4), 16);
                            if (l < 0L || (l & Double.doubleToRawLongBits(Double.NaN)) != 0L) {
                                throw new AssemblerException("Unrecognized NaN value: " + string2);
                            }
                            if (string2.startsWith("NaN-")) {
                                l ^= Long.MIN_VALUE;
                            }
                            assemblerConstant.type = AssemblerConstant.Type.NAN;
                            assemblerConstant.nanValue = l;
                        } else if (this.chunk.number != null) {
                            assemblerConstant.numberValue = Double.parseDouble(string2);
                            assemblerConstant.type = AssemblerConstant.Type.NUMBER;
                        } else if (string2.contains(".") || string2.contains("E") || string2.contains("e")) {
                            assemblerConstant.numberValue = Double.parseDouble(string2);
                            assemblerConstant.type = AssemblerConstant.Type.FLOAT;
                        } else {
                            assemblerConstant.integerValue = new BigInteger(string2);
                            assemblerConstant.type = AssemblerConstant.Type.INTEGER;
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new AssemblerException("Unrecognized constant value: " + string2);
                    }
                }
                this.constants.add(assemblerConstant);
                break;
            }
            case LINE: {
                this.lines.add(assembler.getInteger());
                break;
            }
            case ABSLINEINFO: {
                AssemblerAbsLineInfo assemblerAbsLineInfo = new AssemblerAbsLineInfo();
                assemblerAbsLineInfo.pc = assembler.getInteger();
                assemblerAbsLineInfo.line = assembler.getInteger();
                this.abslineinfo.add(assemblerAbsLineInfo);
                break;
            }
            case LOCAL: {
                AssemblerLocal assemblerLocal = new AssemblerLocal();
                assemblerLocal.name = assembler.getString();
                assemblerLocal.begin = assembler.getInteger();
                assemblerLocal.end = assembler.getInteger();
                this.locals.add(assemblerLocal);
                break;
            }
            case UPVALUE: {
                AssemblerUpvalue assemblerUpvalue = new AssemblerUpvalue();
                assemblerUpvalue.name = assembler.getString();
                assemblerUpvalue.index = assembler.getInteger();
                assemblerUpvalue.instack = assembler.getBoolean();
                this.upvalues.add(assemblerUpvalue);
                break;
            }
            default: {
                throw new IllegalStateException("Unhandled directive: " + String.valueOf((Object)directive));
            }
        }
    }

    public void processOp(Assembler assembler, CodeExtract codeExtract, Op op, int n) throws AssemblerException, IOException {
        if (!this.hasMaxStackSize) {
            throw new AssemblerException("Expected .maxstacksize before code");
        }
        if (n >= 0 && !codeExtract.op.check(n)) {
            throw new IllegalStateException("Invalid opcode: " + n);
        }
        int n2 = n >= 0 ? codeExtract.op.encode(n) : 0;
        for (OperandFormat operandFormat : op.operands) {
            int n3;
            CodeExtract.Field field = switch (operandFormat.field) {
                case OperandFormat.Field.A -> codeExtract.A;
                case OperandFormat.Field.B -> codeExtract.B;
                case OperandFormat.Field.C -> codeExtract.C;
                case OperandFormat.Field.k -> codeExtract.k;
                case OperandFormat.Field.Ax -> codeExtract.Ax;
                case OperandFormat.Field.sJ -> codeExtract.sJ;
                case OperandFormat.Field.Bx -> codeExtract.Bx;
                case OperandFormat.Field.sBx -> codeExtract.sBx;
                case OperandFormat.Field.x -> codeExtract.x;
                default -> throw new IllegalStateException("Unhandled field: " + String.valueOf((Object)operandFormat.field));
            };
            switch (operandFormat.format) {
                case RAW: 
                case IMMEDIATE_INTEGER: 
                case IMMEDIATE_FLOAT: {
                    n3 = assembler.getInteger();
                    break;
                }
                case IMMEDIATE_SIGNED_INTEGER: {
                    n3 = assembler.getInteger();
                    n3 += field.max() / 2;
                    break;
                }
                case REGISTER: {
                    n3 = assembler.getRegister();
                    break;
                }
                case REGISTER_K: {
                    Object object = assembler.getRegisterK54();
                    n3 = ((Assembler.RKInfo)object).x;
                    if (!((Assembler.RKInfo)object).constant) break;
                    n3 += this.chunk.version.rkoffset.get().intValue();
                    break;
                }
                case REGISTER_K54: {
                    Object object = assembler.getRegisterK54();
                    n2 |= codeExtract.k.encode(((Assembler.RKInfo)object).constant ? 1 : 0);
                    n3 = ((Assembler.RKInfo)object).x;
                    break;
                }
                case CONSTANT: 
                case CONSTANT_INTEGER: 
                case CONSTANT_STRING: {
                    n3 = assembler.getConstant();
                    break;
                }
                case UPVALUE: {
                    n3 = assembler.getUpvalue();
                    break;
                }
                case FUNCTION: {
                    Object object = new FunctionFixup(this);
                    ((FunctionFixup)object).code_index = this.code.size();
                    ((FunctionFixup)object).function = assembler.getAny();
                    ((FunctionFixup)object).field = field;
                    this.f_fixup.add((FunctionFixup)object);
                    n3 = 0;
                    break;
                }
                case JUMP: {
                    Object object = new JumpFixup(this);
                    ((JumpFixup)object).code_index = this.code.size();
                    ((JumpFixup)object).label = assembler.getAny();
                    ((JumpFixup)object).field = field;
                    ((JumpFixup)object).negate = false;
                    this.j_fixup.add((JumpFixup)object);
                    n3 = 0;
                    break;
                }
                case JUMP_NEGATIVE: {
                    Object object = new JumpFixup(this);
                    ((JumpFixup)object).code_index = this.code.size();
                    ((JumpFixup)object).label = assembler.getAny();
                    ((JumpFixup)object).field = field;
                    ((JumpFixup)object).negate = true;
                    this.j_fixup.add((JumpFixup)object);
                    n3 = 0;
                    break;
                }
                default: {
                    throw new IllegalStateException("Unhandled operand format: " + String.valueOf((Object)operandFormat.format));
                }
            }
            if (!field.check(n3)) {
                throw new AssemblerException("Operand " + String.valueOf((Object)operandFormat.field) + " out of range");
            }
            n2 |= field.encode(n3);
        }
        this.code.add(n2);
    }

    public void fixup(CodeExtract codeExtract) throws AssemblerException {
        int n;
        int n2;
        int n3;
        for (FunctionFixup object : this.f_fixup) {
            n3 = this.code.get(object.code_index);
            n2 = -1;
            for (n = 0; n < this.children.size(); ++n) {
                AssemblerFunction assemblerFunction = this.children.get(n);
                if (!object.function.equals(assemblerFunction.name)) continue;
                n2 = n;
                break;
            }
            if (n2 == -1) {
                throw new AssemblerException("Unknown function: " + object.function);
            }
            n3 = object.field.clear(n3);
            this.code.set(object.code_index, n3 |= object.field.encode(n2));
        }
        for (JumpFixup jumpFixup : this.j_fixup) {
            n3 = this.code.get(jumpFixup.code_index);
            n2 = 0;
            n = 0;
            for (AssemblerLabel assemblerLabel : this.labels) {
                if (!jumpFixup.label.equals(assemblerLabel.name)) continue;
                n2 = assemblerLabel.code_index - jumpFixup.code_index - 1;
                if (jumpFixup.negate) {
                    n2 = -n2;
                }
                n = 1;
                break;
            }
            if (n == 0) {
                throw new AssemblerException("Unknown label: " + jumpFixup.label);
            }
            n3 = jumpFixup.field.clear(n3);
            this.code.set(jumpFixup.code_index, n3 |= jumpFixup.field.encode(n2));
        }
        for (AssemblerFunction assemblerFunction : this.children) {
            assemblerFunction.fixup(codeExtract);
        }
    }

    class FunctionFixup {
        int code_index;
        String function;
        CodeExtract.Field field;

        FunctionFixup(AssemblerFunction assemblerFunction) {
        }
    }

    class JumpFixup {
        int code_index;
        String label;
        CodeExtract.Field field;
        boolean negate;

        JumpFixup(AssemblerFunction assemblerFunction) {
        }
    }
}

