/*
 * Decompiled with CFR 0.152.
 */
package unluac.assemble;

import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import unluac.Version;
import unluac.assemble.Assembler;
import unluac.assemble.AssemblerAbsLineInfo;
import unluac.assemble.AssemblerConstant;
import unluac.assemble.AssemblerException;
import unluac.assemble.AssemblerFunction;
import unluac.assemble.AssemblerLocal;
import unluac.assemble.AssemblerUpvalue;
import unluac.assemble.Directive;
import unluac.decompile.CodeExtract;
import unluac.decompile.Op;
import unluac.decompile.Type;
import unluac.decompile.TypeMap;
import unluac.parse.BHeader;
import unluac.parse.BInteger;
import unluac.parse.BIntegerType;
import unluac.parse.LAbsLineInfo;
import unluac.parse.LAbsLineInfoType;
import unluac.parse.LBoolean;
import unluac.parse.LBooleanType;
import unluac.parse.LConstantType;
import unluac.parse.LFunction;
import unluac.parse.LFunctionType;
import unluac.parse.LHeader;
import unluac.parse.LLocal;
import unluac.parse.LLocalType;
import unluac.parse.LNil;
import unluac.parse.LNumber;
import unluac.parse.LNumberType;
import unluac.parse.LObject;
import unluac.parse.LString;
import unluac.parse.LStringType;
import unluac.parse.LUpvalue;
import unluac.parse.LUpvalueType;

class AssemblerChunk {
    public Version version;
    public int format;
    public LHeader.LEndianness endianness;
    public int int_size;
    public BIntegerType integer;
    public int size_t_size;
    public BIntegerType sizeT;
    public int instruction_size;
    public int op_size;
    public int a_size;
    public int b_size;
    public int c_size;
    public Map<Integer, Type> usertypemap;
    public Map<Integer, Op> useropmap;
    public boolean number_integral;
    public int number_size;
    public LNumberType number;
    public LNumberType linteger;
    public LNumberType lfloat;
    public AssemblerFunction main;
    public AssemblerFunction current;
    public CodeExtract extract;
    public final Set<Directive> processed_directives;

    public AssemblerChunk(Version version) {
        this.version = version;
        this.processed_directives = new HashSet<Directive>();
        this.main = null;
        this.current = null;
        this.extract = null;
    }

    public void processHeaderDirective(Assembler assembler, Directive directive) throws AssemblerException, IOException {
        if (!directive.repeatable && this.processed_directives.contains((Object)directive)) {
            throw new AssemblerException("Duplicate " + directive.name() + " directive");
        }
        this.processed_directives.add(directive);
        block0 : switch (directive) {
            case FORMAT: {
                this.format = assembler.getInteger();
                break;
            }
            case ENDIANNESS: {
                String string;
                switch (string = assembler.getName()) {
                    case "LITTLE": {
                        this.endianness = LHeader.LEndianness.LITTLE;
                        break block0;
                    }
                    case "BIG": {
                        this.endianness = LHeader.LEndianness.BIG;
                        break block0;
                    }
                }
                throw new AssemblerException("Unknown endianness \"" + string + "\"");
            }
            case INT_SIZE: {
                this.int_size = assembler.getInteger();
                this.integer = BIntegerType.create50Type(true, this.int_size, this.version.allownegativeint.get());
                break;
            }
            case SIZE_T_SIZE: {
                this.size_t_size = assembler.getInteger();
                this.sizeT = BIntegerType.create50Type(false, this.size_t_size, false);
                break;
            }
            case INSTRUCTION_SIZE: {
                this.instruction_size = assembler.getInteger();
                break;
            }
            case SIZE_OP: {
                this.op_size = assembler.getInteger();
                break;
            }
            case SIZE_A: {
                this.a_size = assembler.getInteger();
                break;
            }
            case SIZE_B: {
                this.b_size = assembler.getInteger();
                break;
            }
            case SIZE_C: {
                this.c_size = assembler.getInteger();
                break;
            }
            case NUMBER_FORMAT: {
                String string;
                switch (string = assembler.getName()) {
                    case "integer": {
                        this.number_integral = true;
                        break;
                    }
                    case "float": {
                        this.number_integral = false;
                        break;
                    }
                    default: {
                        throw new AssemblerException("Unknown number_format \"" + string + "\"");
                    }
                }
                this.number_size = assembler.getInteger();
                this.number = new LNumberType(this.number_size, this.number_integral, LNumberType.NumberMode.MODE_NUMBER);
                break;
            }
            case INTEGER_FORMAT: {
                this.linteger = new LNumberType(assembler.getInteger(), true, LNumberType.NumberMode.MODE_INTEGER);
                break;
            }
            case FLOAT_FORMAT: {
                this.lfloat = new LNumberType(assembler.getInteger(), false, LNumberType.NumberMode.MODE_FLOAT);
                break;
            }
            case TYPE: {
                if (this.usertypemap == null) {
                    this.usertypemap = new HashMap<Integer, Type>();
                }
                int n = assembler.getInteger();
                String string = assembler.getName();
                Type type = Type.get(string);
                if (type == null) {
                    throw new AssemblerException("Unknown type name \"" + string + "\"");
                }
                this.usertypemap.put(n, type);
                break;
            }
            case OP: {
                if (this.useropmap == null) {
                    this.useropmap = new HashMap<Integer, Op>();
                }
                int n = assembler.getInteger();
                String string = assembler.getName();
                Op op = this.version.getOpcodeMap().get(string);
                if (op == null) {
                    throw new AssemblerException("Unknown op name \"" + string + "\"");
                }
                this.useropmap.put(n, op);
                break;
            }
            default: {
                throw new IllegalStateException("Unhandled directive: " + String.valueOf((Object)directive));
            }
        }
    }

    public CodeExtract getCodeExtract() throws AssemblerException {
        if (this.extract == null) {
            this.extract = new CodeExtract(this.version, this.op_size, this.a_size, this.b_size, this.c_size);
        }
        return this.extract;
    }

    public void processNewFunction(Assembler assembler) throws AssemblerException, IOException {
        String string = assembler.getName();
        String[] stringArray = string.split("/");
        if (this.main == null) {
            if (stringArray.length != 1) {
                throw new AssemblerException("First (main) function declaration must not have a \"/\" in the name");
            }
            this.current = this.main = new AssemblerFunction(this, null, string);
        } else {
            if (stringArray.length == 1 || !stringArray[0].equals(this.main.name)) {
                throw new AssemblerException("Function \"" + string + "\" isn't contained in the main function");
            }
            AssemblerFunction assemblerFunction = this.main.getInnerParent(stringArray, 1);
            this.current = assemblerFunction.addChild(stringArray[stringArray.length - 1]);
        }
    }

    public void processFunctionDirective(Assembler assembler, Directive directive) throws AssemblerException, IOException {
        if (this.current == null) {
            throw new AssemblerException("Misplaced function directive before declaration of any function");
        }
        this.current.processFunctionDirective(assembler, directive);
    }

    public void processOp(Assembler assembler, Op op, int n) throws AssemblerException, IOException {
        if (this.current == null) {
            throw new AssemblerException("Misplaced code before declaration of any function");
        }
        this.current.processOp(assembler, this.getCodeExtract(), op, n);
    }

    public void fixup() throws AssemblerException {
        this.main.fixup(this.getCodeExtract());
    }

    public void write(OutputStream outputStream) throws AssemblerException, IOException {
        LBooleanType lBooleanType = new LBooleanType();
        LStringType lStringType = this.version.getLStringType();
        LConstantType lConstantType = this.version.getLConstantType();
        LAbsLineInfoType lAbsLineInfoType = new LAbsLineInfoType();
        LLocalType lLocalType = new LLocalType();
        LUpvalueType lUpvalueType = this.version.getLUpvalueType();
        LFunctionType lFunctionType = this.version.getLFunctionType();
        CodeExtract codeExtract = this.getCodeExtract();
        if (this.integer == null) {
            this.sizeT = this.integer = BIntegerType.create54();
        }
        TypeMap typeMap = this.usertypemap != null ? new TypeMap(this.usertypemap) : this.version.getTypeMap();
        LHeader lHeader = new LHeader(this.format, this.endianness, this.integer, this.sizeT, lBooleanType, this.number, this.linteger, this.lfloat, lStringType, lConstantType, lAbsLineInfoType, lLocalType, lUpvalueType, lFunctionType, codeExtract);
        BHeader bHeader = new BHeader(this.version, lHeader, typeMap);
        LFunction lFunction = this.convert_function(bHeader, this.main);
        bHeader = new BHeader(this.version, lHeader, typeMap, lFunction);
        bHeader.write(outputStream);
    }

    /*
     * WARNING - void declaration
     */
    private LFunction convert_function(BHeader bHeader, AssemblerFunction assemblerFunction) {
        int[] nArray = new int[assemblerFunction.code.size()];
        int n = 0;
        Object object = assemblerFunction.code.iterator();
        while (object.hasNext()) {
            int n2 = object.next();
            nArray[n++] = n2;
        }
        object = new int[assemblerFunction.lines.size()];
        n = 0;
        LAbsLineInfo[] lAbsLineInfoArray = assemblerFunction.lines.iterator();
        while (lAbsLineInfoArray.hasNext()) {
            int n3 = lAbsLineInfoArray.next();
            object[n++] = n3;
        }
        lAbsLineInfoArray = new LAbsLineInfo[assemblerFunction.abslineinfo.size()];
        n = 0;
        for (AssemblerAbsLineInfo lObjectArray2 : assemblerFunction.abslineinfo) {
            lAbsLineInfoArray[n++] = new LAbsLineInfo(lObjectArray2.pc, lObjectArray2.line);
        }
        LLocal[] lLocalArray = new LLocal[assemblerFunction.locals.size()];
        n = 0;
        for (AssemblerLocal assemblerLocal : assemblerFunction.locals) {
            lLocalArray[n++] = new LLocal(this.convert_string(bHeader, assemblerLocal.name), new BInteger(assemblerLocal.begin), new BInteger(assemblerLocal.end));
        }
        LObject[] lObjectArray = new LObject[assemblerFunction.constants.size()];
        n = 0;
        for (AssemblerConstant assemblerConstant : assemblerFunction.constants) {
            void var11_19;
            switch (assemblerConstant.type) {
                case NIL: {
                    LNil lNil = LNil.NIL;
                    break;
                }
                case BOOLEAN: {
                    LBoolean lBoolean = assemblerConstant.booleanValue ? LBoolean.LTRUE : LBoolean.LFALSE;
                    break;
                }
                case NUMBER: {
                    LNumber lNumber = bHeader.number.create(assemblerConstant.numberValue);
                    break;
                }
                case INTEGER: {
                    LNumber lNumber = bHeader.linteger.create(assemblerConstant.integerValue);
                    break;
                }
                case FLOAT: {
                    LNumber lNumber = bHeader.lfloat.create(assemblerConstant.numberValue);
                    break;
                }
                case STRING: {
                    LString lString = this.convert_string(bHeader, assemblerConstant.stringValue);
                    break;
                }
                case LONGSTRING: {
                    LString lString = this.convert_long_string(bHeader, assemblerConstant.stringValue);
                    break;
                }
                case NAN: {
                    if (bHeader.number != null) {
                        LNumber lNumber = bHeader.number.createNaN(assemblerConstant.nanValue);
                        break;
                    }
                    LNumber lNumber = bHeader.lfloat.createNaN(assemblerConstant.nanValue);
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
            lObjectArray[n++] = var11_19;
        }
        LUpvalue[] lUpvalueArray = new LUpvalue[assemblerFunction.upvalues.size()];
        n = 0;
        for (AssemblerUpvalue assemblerUpvalue : assemblerFunction.upvalues) {
            LUpvalue lUpvalue = new LUpvalue();
            lUpvalue.bname = this.convert_string(bHeader, assemblerUpvalue.name);
            lUpvalue.idx = assemblerUpvalue.index;
            lUpvalue.instack = assemblerUpvalue.instack;
            lUpvalueArray[n++] = lUpvalue;
        }
        LFunction[] lFunctionArray = new LFunction[assemblerFunction.children.size()];
        n = 0;
        for (AssemblerFunction assemblerFunction2 : assemblerFunction.children) {
            lFunctionArray[n++] = this.convert_function(bHeader, assemblerFunction2);
        }
        return new LFunction(bHeader, this.convert_string(bHeader, assemblerFunction.source), assemblerFunction.linedefined, assemblerFunction.lastlinedefined, nArray, (int[])object, lAbsLineInfoArray, lLocalArray, lObjectArray, lUpvalueArray, lFunctionArray, assemblerFunction.maxStackSize, assemblerFunction.upvalues.size(), assemblerFunction.numParams, assemblerFunction.vararg);
    }

    private LString convert_string(BHeader bHeader, String string) {
        if (string == null) {
            return LString.NULL;
        }
        return new LString(string, '\u0000');
    }

    private LString convert_long_string(BHeader bHeader, String string) {
        return new LString(string, '\u0000', true);
    }
}

