/*
 * Decompiled with CFR 0.152.
 */
package unluac.assemble;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import unluac.Configuration;
import unluac.Version;
import unluac.assemble.AssemblerChunk;
import unluac.assemble.AssemblerException;
import unluac.assemble.Directive;
import unluac.assemble.Tokenizer;
import unluac.decompile.Op;
import unluac.decompile.OpcodeMap;
import unluac.util.StringUtils;

public class Assembler {
    private Configuration config;
    private Tokenizer t;
    private OutputStream out;
    private Version version;

    public Assembler(Configuration configuration, InputStream inputStream, OutputStream outputStream) {
        this.config = configuration;
        this.t = new Tokenizer(inputStream);
        this.out = outputStream;
    }

    public void assemble() throws AssemblerException, IOException {
        int n;
        int n2;
        String string = this.t.next();
        if (!string.equals(".version")) {
            throw new AssemblerException("First directive must be .version, instead was \"" + string + "\"");
        }
        string = this.t.next();
        String[] stringArray = string.split("\\.");
        if (stringArray.length == 2) {
            try {
                n2 = Integer.valueOf(stringArray[0]);
                n = Integer.valueOf(stringArray[1]);
            }
            catch (NumberFormatException numberFormatException) {
                throw new AssemblerException("Unsupported version " + string);
            }
        } else {
            throw new AssemblerException("Unsupported version " + string);
        }
        if (n2 < 0 || n2 > 15 || n < 0 || n > 15) {
            throw new AssemblerException("Unsupported version " + string);
        }
        this.version = Version.getVersion(this.config, n2, n);
        if (this.version == null) {
            throw new AssemblerException("Unsupported version " + string);
        }
        HashMap<String, Op> hashMap = null;
        HashMap<Op, Integer> hashMap2 = null;
        AssemblerChunk assemblerChunk = new AssemblerChunk(this.version);
        boolean bl = false;
        block7: while ((string = this.t.next()) != null) {
            Object object;
            Directive directive = Directive.lookup.get(string);
            if (directive != null) {
                switch (directive.type) {
                    case HEADER: {
                        assemblerChunk.processHeaderDirective(this, directive);
                        continue block7;
                    }
                    case NEWFUNCTION: {
                        if (!bl) {
                            bl = true;
                            object = assemblerChunk.useropmap != null ? new OpcodeMap(assemblerChunk.useropmap) : this.version.getOpcodeMap();
                            hashMap = new HashMap<String, Op>();
                            hashMap2 = new HashMap<Op, Integer>();
                            for (int i = 0; i < ((OpcodeMap)object).size(); ++i) {
                                Op op = ((OpcodeMap)object).get(i);
                                if (op == null) continue;
                                hashMap.put(op.name, op);
                                hashMap2.put(op, i);
                            }
                            hashMap.put(Op.EXTRABYTE.name, Op.EXTRABYTE);
                            hashMap2.put(Op.EXTRABYTE, -1);
                        }
                        assemblerChunk.processNewFunction(this);
                        continue block7;
                    }
                    case FUNCTION: {
                        assemblerChunk.processFunctionDirective(this, directive);
                        continue block7;
                    }
                }
                throw new IllegalStateException();
            }
            object = (Op)((Object)hashMap.get(string));
            if (object != null) {
                assemblerChunk.processOp(this, (Op)((Object)object), (Integer)hashMap2.get(object));
                continue;
            }
            throw new AssemblerException("Unexpected token \"" + string + "\"");
        }
        assemblerChunk.fixup();
        assemblerChunk.write(this.out);
    }

    String getAny() throws AssemblerException, IOException {
        String string = this.t.next();
        if (string == null) {
            throw new AssemblerException("Unexcepted end of file");
        }
        return string;
    }

    String getName() throws AssemblerException, IOException {
        String string = this.t.next();
        if (string == null) {
            throw new AssemblerException("Unexcepted end of file");
        }
        return string;
    }

    String getString() throws AssemblerException, IOException {
        String string = this.t.next();
        if (string == null) {
            throw new AssemblerException("Unexcepted end of file");
        }
        return StringUtils.fromPrintString(string);
    }

    int getInteger() throws AssemblerException, IOException {
        int n;
        String string = this.t.next();
        if (string == null) {
            throw new AssemblerException("Unexcepted end of file");
        }
        try {
            n = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new AssemblerException("Excepted number, got \"" + string + "\"");
        }
        return n;
    }

    boolean getBoolean() throws AssemblerException, IOException {
        boolean bl;
        String string = this.t.next();
        if (string == null) {
            throw new AssemblerException("Unexcepted end of file");
        }
        if (string.equals("true")) {
            bl = true;
        } else if (string.equals("false")) {
            bl = false;
        } else {
            throw new AssemblerException("Expected boolean, got \"" + string + "\"");
        }
        return bl;
    }

    int getRegister() throws AssemblerException, IOException {
        int n;
        String string = this.t.next();
        if (string == null) {
            throw new AssemblerException("Unexcepted end of file");
        }
        if (string.length() >= 2 && string.charAt(0) == 'r') {
            try {
                n = Integer.parseInt(string.substring(1));
            }
            catch (NumberFormatException numberFormatException) {
                throw new AssemblerException("Excepted register, got \"" + string + "\"");
            }
        } else {
            throw new AssemblerException("Excepted register, got \"" + string + "\"");
        }
        return n;
    }

    RKInfo getRegisterK54() throws AssemblerException, IOException {
        String string = this.t.next();
        if (string == null) {
            throw new AssemblerException("Unexcepted end of file");
        }
        RKInfo rKInfo = new RKInfo();
        if (string.length() >= 2 && string.charAt(0) == 'r') {
            rKInfo.constant = false;
            try {
                rKInfo.x = Integer.parseInt(string.substring(1));
            }
            catch (NumberFormatException numberFormatException) {
                throw new AssemblerException("Excepted register, got \"" + string + "\"");
            }
        } else if (string.length() >= 2 && string.charAt(0) == 'k') {
            rKInfo.constant = true;
            try {
                rKInfo.x = Integer.parseInt(string.substring(1));
            }
            catch (NumberFormatException numberFormatException) {
                throw new AssemblerException("Excepted constant, got \"" + string + "\"");
            }
        } else {
            throw new AssemblerException("Excepted register or constant, got \"" + string + "\"");
        }
        return rKInfo;
    }

    int getConstant() throws AssemblerException, IOException {
        int n;
        String string = this.t.next();
        if (string == null) {
            throw new AssemblerException("Unexpected end of file");
        }
        if (string.length() >= 2 && string.charAt(0) == 'k') {
            try {
                n = Integer.parseInt(string.substring(1));
            }
            catch (NumberFormatException numberFormatException) {
                throw new AssemblerException("Excepted constant, got \"" + string + "\"");
            }
        } else {
            throw new AssemblerException("Excepted constant, got \"" + string + "\"");
        }
        return n;
    }

    int getUpvalue() throws AssemblerException, IOException {
        int n;
        String string = this.t.next();
        if (string == null) {
            throw new AssemblerException("Unexcepted end of file");
        }
        if (string.length() >= 2 && string.charAt(0) == 'u') {
            try {
                n = Integer.parseInt(string.substring(1));
            }
            catch (NumberFormatException numberFormatException) {
                throw new AssemblerException("Excepted register, got \"" + string + "\"");
            }
        } else {
            throw new AssemblerException("Excepted register, got \"" + string + "\"");
        }
        return n;
    }

    static class RKInfo {
        int x;
        boolean constant;

        RKInfo() {
        }
    }
}

