/*
 * Decompiled with CFR 0.152.
 */
package unluac;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import unluac.Configuration;
import unluac.assemble.Assembler;
import unluac.assemble.AssemblerException;
import unluac.decompile.Decompiler;
import unluac.decompile.Disassembler;
import unluac.decompile.FileOutputProvider;
import unluac.decompile.Output;
import unluac.parse.BHeader;
import unluac.parse.LFunction;
import unluac.util.FileUtils;

public class Main {
    public static String version = "1.2.3.530";
    public static String currentFile = null;

    public static void main(String[] stringArray) {
        Object object;
        String string = null;
        Configuration configuration = new Configuration();
        for (int i = 0; i < stringArray.length; ++i) {
            object = stringArray[i];
            if (((String)object).startsWith("-")) {
                if (((String)object).equals("--rawstring")) {
                    configuration.rawstring = true;
                    continue;
                }
                if (((String)object).equals("--luaj")) {
                    configuration.luaj = true;
                    continue;
                }
                if (((String)object).equals("--nodebug")) {
                    configuration.variable = Configuration.VariableMode.NODEBUG;
                    continue;
                }
                if (((String)object).equals("--disassemble")) {
                    configuration.mode = Configuration.Mode.DISASSEMBLE;
                    continue;
                }
                if (((String)object).equals("--assemble")) {
                    configuration.mode = Configuration.Mode.ASSEMBLE;
                    continue;
                }
                if (((String)object).equals("--help")) {
                    configuration.mode = Configuration.Mode.HELP;
                    continue;
                }
                if (((String)object).equals("--version")) {
                    configuration.mode = Configuration.Mode.VERSION;
                    continue;
                }
                if (((String)object).equals("--output") || ((String)object).equals("-o")) {
                    if (i + 1 < stringArray.length) {
                        configuration.output = stringArray[i + 1];
                        ++i;
                        continue;
                    }
                    Main.error("option \"" + (String)object + "\" doesn't have an argument", true);
                    continue;
                }
                if (((String)object).equals("--typemap")) {
                    if (i + 1 < stringArray.length) {
                        configuration.typemap = stringArray[i + 1];
                        ++i;
                        continue;
                    }
                    Main.error("option \"" + (String)object + "\" doesn't have an argument", true);
                    continue;
                }
                if (((String)object).equals("--opmap")) {
                    if (i + 1 < stringArray.length) {
                        configuration.opmap = stringArray[i + 1];
                        ++i;
                        continue;
                    }
                    Main.error("option \"" + (String)object + "\" doesn't have an argument", true);
                    continue;
                }
                Main.error("unrecognized option: " + (String)object, true);
                continue;
            }
            if (string == null) {
                string = object;
                continue;
            }
            Main.error("too many arguments: " + (String)object, true);
        }
        if (string == null && configuration.mode != Configuration.Mode.HELP && configuration.mode != Configuration.Mode.VERSION) {
            Main.error("no input file provided", true);
        } else {
            switch (configuration.mode) {
                case HELP: {
                    Main.help();
                    break;
                }
                case VERSION: {
                    System.out.println(version);
                    break;
                }
                case DECOMPILE: {
                    LFunction lFunction = null;
                    try {
                        lFunction = Main.file_to_function(string, configuration);
                    }
                    catch (IOException iOException) {
                        Main.error(iOException.getMessage(), false);
                    }
                    object = new Decompiler(lFunction);
                    Decompiler.State state = ((Decompiler)object).decompile();
                    Output output = configuration.getOutput();
                    ((Decompiler)object).print(state, output);
                    output.finish();
                    break;
                }
                case DISASSEMBLE: {
                    LFunction lFunction = null;
                    try {
                        lFunction = Main.file_to_function(string, configuration);
                    }
                    catch (IOException iOException) {
                        Main.error(iOException.getMessage(), false);
                    }
                    object = new Disassembler(lFunction);
                    Output output = configuration.getOutput();
                    ((Disassembler)object).disassemble(output);
                    output.finish();
                    break;
                }
                case ASSEMBLE: {
                    if (configuration.output == null) {
                        Main.error("assembler mode requires an output file", true);
                        break;
                    }
                    try {
                        Assembler assembler = new Assembler(configuration, FileUtils.createSmartTextFileReader(new File(string)), new FileOutputStream(configuration.output));
                        assembler.assemble();
                    }
                    catch (IOException iOException) {
                        Main.error(iOException.getMessage(), false);
                    }
                    catch (AssemblerException assemblerException) {
                        Main.error(assemblerException.getMessage(), false);
                    }
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
            System.exit(0);
        }
    }

    public static void error(String string, boolean bl) {
        Main.print_unluac_string(System.err);
        System.err.print("  error: ");
        System.err.println(string);
        if (bl) {
            Main.print_usage(System.err);
            System.err.println("For information about options, use option: --help");
        }
        System.exit(1);
    }

    public static void help() {
        Main.print_unluac_string(System.out);
        Main.print_usage(System.out);
        System.out.println("Available options are:");
        System.out.println("  --assemble        assemble given disassembly listing");
        System.out.println("  --disassemble     disassemble instead of decompile");
        System.out.println("  --nodebug         ignore debugging information in input file");
        System.out.println("  --typemap <file>  use type mapping specified in <file>");
        System.out.println("  --opmap <file>    use opcode mapping specified in <file>");
        System.out.println("  --output <file>   output to <file> instead of stdout");
        System.out.println("  --rawstring       copy string bytes directly to output");
        System.out.println("  --luaj            emulate Luaj's permissive parser");
    }

    private static void print_unluac_string(PrintStream printStream) {
        printStream.println("unluac v" + version);
    }

    private static void print_usage(PrintStream printStream) {
        printStream.println("  usage: java -jar unluac.jar [options] <file>");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static LFunction file_to_function(String string, Configuration configuration) throws IOException {
        RandomAccessFile randomAccessFile = null;
        try {
            currentFile = string;
            randomAccessFile = new RandomAccessFile(string, "r");
            ByteBuffer byteBuffer = ByteBuffer.allocate((int)randomAccessFile.length());
            byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
            FileChannel fileChannel = randomAccessFile.getChannel();
            for (int i = (int)randomAccessFile.length(); i > 0; i -= fileChannel.read(byteBuffer)) {
            }
            byteBuffer.rewind();
            BHeader bHeader = new BHeader(byteBuffer, configuration);
            LFunction lFunction = bHeader.main;
            return lFunction;
        }
        finally {
            currentFile = null;
            if (randomAccessFile != null) {
                randomAccessFile.close();
            }
        }
    }

    public static void decompile(String string, String string2, Configuration configuration) throws IOException {
        LFunction lFunction = Main.file_to_function(string, configuration);
        Decompiler decompiler = new Decompiler(lFunction);
        Decompiler.State state = decompiler.decompile();
        Output output = new Output(new FileOutputProvider(new FileOutputStream(string2)));
        decompiler.print(state, output);
        output.finish();
    }

    public static void assemble(String string, String string2) throws IOException, AssemblerException {
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(new File(string2)));
        Assembler assembler = new Assembler(new Configuration(), FileUtils.createSmartTextFileReader(new File(string)), bufferedOutputStream);
        assembler.assemble();
        ((OutputStream)bufferedOutputStream).flush();
        ((OutputStream)bufferedOutputStream).close();
    }

    public static void disassemble(String string, String string2) throws IOException {
        LFunction lFunction = Main.file_to_function(string, new Configuration());
        Disassembler disassembler = new Disassembler(lFunction);
        Output output = new Output(new FileOutputProvider(new FileOutputStream(string2)));
        disassembler.disassemble(output);
        output.finish();
    }
}

