/*
 * Decompiled with CFR 0.152.
 */
package unluac;

import java.io.FileOutputStream;
import java.io.IOException;
import unluac.Main;
import unluac.decompile.FileOutputProvider;
import unluac.decompile.Output;

public class Configuration {
    public boolean rawstring;
    public Mode mode;
    public VariableMode variable;
    public boolean strict_scope;
    public boolean luaj;
    public String typemap;
    public String opmap;
    public String output;

    public Configuration() {
        this.rawstring = false;
        this.mode = Mode.DECOMPILE;
        this.variable = VariableMode.DEFAULT;
        this.strict_scope = false;
        this.luaj = false;
        this.opmap = null;
        this.output = null;
    }

    public Configuration(Configuration configuration) {
        this.rawstring = configuration.rawstring;
        this.mode = configuration.mode;
        this.variable = configuration.variable;
        this.strict_scope = configuration.strict_scope;
        this.opmap = configuration.opmap;
        this.output = configuration.output;
    }

    public Output getOutput() {
        if (this.output != null) {
            try {
                return new Output(new FileOutputProvider(new FileOutputStream(this.output)));
            }
            catch (IOException iOException) {
                Main.error(iOException.getMessage(), false);
                return null;
            }
        }
        return new Output();
    }

    public static enum Mode {
        DECOMPILE,
        DISASSEMBLE,
        ASSEMBLE,
        HELP,
        VERSION;

    }

    public static enum VariableMode {
        NODEBUG,
        DEFAULT,
        FINDER;

    }
}

